//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Erlang.h,v 0.30 1996-08-07 18:01:06+02 steppler Exp $
 *
 * CNClass: CNErlang --- CNErlang-k distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#ifndef __Erlang_h
#define __Erlang_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_ERLANG;	// CNClass CNErlang description


/*
 * The class CNErlang
 */

class CNErlang : public CNRandom
{
protected:
    double pMean;
    double pVariance;
    int k;
    double a;
    void setState();

public:
    double mean();
    double mean(double x);
    double variance();
    double variance(double x);

    virtual double operator()() ;

    /***** Constructors ******************************************************/
public:
    CNErlang();        				// Default constructor
    CNErlang(CNParam *param); 			// CNParam constructor
    CNErlang(double mean, double variance, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_ERLANG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_ERLANG ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNErlang *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNErlang *)obj;
#   else
	return (CNErlang *)( !obj || obj->is_a(CN_ERLANG)
	       ? obj : fatal_type(obj->class_desc(), CN_ERLANG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNErlang(param) : new CNErlang; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const ;
    virtual void dump (ostream &strm = cout) const ;
};

#endif /**__Erlang_h**/



