//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HyperExp.c,v 0.30 1996-08-07 18:01:21+02 steppler Exp $
 *
 * CNClass: CNHyperExp --- Hyper exponential (H2) distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "HyperExp.h"




CNHyperExp::CNHyperExp(double p, double m1, double m2, CNRNG *gen)
    : CNRandom(gen)
{
    assert((m1>0) && (m2>0));
    percent = p;
    tau1 = 1 / m1;
    tau2 = 1 / m2;
}

CNHyperExp::CNHyperExp()
	 : CNRandom((CNRNG*)NIL)
{
    percent = 0;
    tau1 = 0;
    tau2 = 0;
}     

CNHyperExp::CNHyperExp(CNParam *)
	 : CNRandom((CNRNG*)NIL)
{
    percent = 0;
    tau1 = 0;
    tau2 = 0;
}     
    


double CNHyperExp::operator()()
{
    double u1,u2;
    
    while ( !( u1 = pGenerator -> as_double() ) );
    while ( !( u2 = pGenerator -> as_double() ) );
    
    if ( u2 <= percent )
	return( (-tau1) * log( u1 ) );
    else
	return( (-tau2) * log( u1 ) );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNHyperExp::print(ostream &strm) const
{
    strm << "p=" << percent << " mu1=" << tau1 << " mu2=" << tau2 << endl;
}

// Debug output
void CNHyperExp::dump(ostream &strm) const
{
    strm << "CNHyperExp { "
	 << "p=" << percent << " mu1=" << tau1 << " mu2=" << tau2
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNHyperExp
static CNClass CNHyperExp_desc("CNHyperExp", "$Revision: 0.30 $",
			   CNHyperExp::new_object);

// "Type" for type checking functions
CNClassDesc CN_HYPEREXP = &CNHyperExp_desc;






