//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: HyperGeom.c,v 0.30 1996-08-07 18:01:23+02 steppler Exp $
 *
 * CNClass: CNHyperGeom --- Hyper geometric distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "HyperGeom.h"




void CNHyperGeom::setState()
{
    double z = pVariance / (pMean * pMean);
    pP = 0.5 * (1.0 - sqrt((z - 1.0) / ( z + 1.0 )));
}

CNHyperGeom::CNHyperGeom(double mean, double variance, CNRNG *gen)
    : CNRandom(gen)
{
    pMean = mean; 
    pVariance = variance;
    setState();
}

CNHyperGeom::CNHyperGeom()
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    pP = 0;
}

CNHyperGeom::CNHyperGeom(CNParam *)
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    pP = 0;
}
	
double CNHyperGeom::mean() { return pMean; };

double CNHyperGeom::mean(double x)
{
    double t = pMean; 
    pMean = x;
    setState(); 
    return t;
}

double CNHyperGeom::variance() { return pVariance; }

double CNHyperGeom::variance(double x)
{
    double t = pVariance; 
    pVariance = x;
    setState(); 
    return t;
}



double CNHyperGeom::operator()()
{
    double d = (pGenerator -> as_double() > pP) ? (1.0 - pP) :  (pP);
    return(-pMean * log(pGenerator -> as_double()) / (2.0 * d) );
}


/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNHyperGeom::print(ostream &strm) const
{
    strm << "mean = " << pMean << " var = " << pVariance << " p = " << pP << endl;
}

// Debug output
void CNHyperGeom::dump(ostream &strm) const
{
    strm << "CNHyperGeom { "
	 << "mean = " << pMean << " var = " << pVariance << " p = " << pP
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNHyperGeom
static CNClass CNHyperGeom_desc("CNHyperGeom", "$Revision: 0.30 $",
			    CNHyperGeom::new_object);

// "Type" for type checking functions
CNClassDesc CN_HYPERGEOM = &CNHyperGeom_desc;






