//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MDeterm.c,v 0.30 1996-08-07 18:01:35+02 steppler Exp $
 *
 * CNClass: CNMDeterm --- Mixed deterministic random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "MDeterm.h"




CNMDeterm::CNMDeterm(double m, double d1, double d2, CNRNG *gen)
    : CNRandom(gen)
{
    mix = m;
    assert((m>=0) && (m<=1));
    det1 = d1;
    det2 = d2;
}

CNMDeterm::CNMDeterm() : CNRandom ((CNRNG*)NIL)
{
    mix = 0;
    det1 = 0;
    det2 = 0;
}

CNMDeterm::CNMDeterm(CNParam *) : CNRandom((CNRNG*)NIL)
{
    mix = 0;
    det1 = 0;
    det2 = 0;
}
					 
		       

double CNMDeterm::operator()()
{
    if ( pGenerator -> as_double() < mix)
	return(det1);
    else
	return(det2);
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNMDeterm::print(ostream &strm) const
{
    strm << "p=" << mix << " val1=" << det1 << " val2=" << det2 << endl;
}

// Debug output
void CNMDeterm::dump(ostream &strm) const
{
    strm << "CNMDeterm { "
	 << "p=" << mix << " val1=" << det1 << " val2=" << det2
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNMDeterm
static CNClass CNMDeterm_desc("CNMDeterm", "$Revision: 0.30 $", CNMDeterm::new_object);

// "Type" for type checking functions
CNClassDesc CN_MDETERM = &CNMDeterm_desc;






