//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MLCG.c,v 0.30 1996-08-07 18:01:38+02 steppler Exp $
 *
 * CNClass: CNMLCG --- Multiple linear congruence generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "MLCG.h"


#define SEED_TABLE_SIZE 32

static long seed_table[SEED_TABLE_SIZE] = {
    0xbdcc47e5, 0x54aea45d, 0xec0df859, 0xda84637b,
    0xc8c6cb4f, 0x35574b01, 0x28260b7d, 0x0d07fdbf,
    0x9faaeeb0, 0x613dd169, 0x5ce2d818, 0x85b9e706,
    0xab2469db, 0xda02b0dc, 0x45c60d6e, 0xffe49d10,
    0x7224fea3, 0xf9684fc9, 0xfc7ee074, 0x326ce92a,
    0x366d13b5, 0x17aaa731, 0xeb83a675, 0x7781cb32,
    0x4ec7c92d, 0x7f187521, 0x2cf346b4, 0xad13310f,
    0xb89cff2b, 0x12164de1, 0xa865168d, 0x32b56cdf
};



CNMLCG::CNMLCG(long seed1, long seed2)
{
    initialSeedOne = seed1;
    initialSeedTwo = seed2;
    reset();
}



CNMLCG::CNMLCG()
{
    initialSeedOne = 0 ;
    initialSeedTwo = 0 ;
    reset();
} 



CNMLCG::CNMLCG(CNParam *)
{
    initialSeedOne = 0 ;
    initialSeedTwo = 0 ;
    reset();
}   



void CNMLCG::reset()
{
    long seed1 = initialSeedOne;
    long seed2 = initialSeedTwo;

    //
    //  Most people pick stupid seed numbers that do not have enough
    //  bits. In this case, if they pick a small seed number, we
    //  map that to a specific seed.
    //
    if (seed1 < 0) {
	seed1 = (seed1 + 2147483561);
	seed1 = (seed1 < 0) ? -seed1 : seed1;
    }

    if (seed2 < 0) {
	seed2 = (seed2 + 2147483561);
	seed2 = (seed2 < 0) ? -seed2 : seed2;
    }

    if (seed1 > -1 && seed1 < SEED_TABLE_SIZE) {
	seedOne = seed_table[seed1];
    } else {
	seedOne = seed1 ^ seed_table[seed1 & (SEED_TABLE_SIZE-1)];
    }

    if (seed2 > -1 && seed2 < SEED_TABLE_SIZE) {
	seedTwo = seed_table[seed2];
    } else {
	seedTwo = seed2 ^ seed_table[ seed2 & (SEED_TABLE_SIZE-1) ];
    }
    seedOne = (seedOne % 2147483561) + 1;
    seedTwo = (seedTwo % 2147483397) + 1;
}



unsigned long CNMLCG::as_long32()
{
    long k = seedOne % 53668;

    seedOne = 40014 * (seedOne-k * 53668) - k * 12211;
    if (seedOne < 0) {
	seedOne += 2147483563;
    }

    k = seedTwo % 52774;
    seedTwo = 40692 * (seedTwo - k * 52774) - k * 3791;
    if (seedTwo < 0) {
	seedTwo += 2147483399;
    }

    long z = seedOne - seedTwo;
    if (z < 1) {
	z += 2147483562;
    }
    return( (unsigned long) z);
}



void CNMLCG::seed(unsigned long s)
{
    initialSeedOne = s;
    initialSeedTwo = s + 2147483561;
    reset();
}



void CNMLCG::seed_internal(unsigned long s1, unsigned long s2)
{
    initialSeedOne = s1;
    initialSeedTwo = s2;
    reset();
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNMLCG::print(ostream &strm) const
{
    strm << "state = " << seedOne << " , " << seedTwo << endl;
}

// Debug output
void CNMLCG::dump(ostream &strm) const
{
    // ... insert your own stuff here ...
    strm << "CNMLCG { "
	 << "state = " << seedOne << " , " << seedTwo << endl
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNMLCG
static CNClass CNMLCG_desc("CNMLCG", "$Revision: 0.30 $",
			   CNMLCG::new_object);

// "Type" for type checking functions
CNClassDesc CN_MLCG = &CNMLCG_desc;
