//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: NegExp.c,v 0.30 1996-08-07 18:01:41+02 steppler Exp $
 *
 * CNClass: CNNegExp --- Negative exponential distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "NegExp.h"




CNNegExp::CNNegExp(double xmean, CNRNG *gen)
    : CNRandom(gen)
{
    pMean = xmean;
    assert(pMean>0);                    // this line added
}

double CNNegExp::mean() { return pMean; }

double CNNegExp::mean(double x)
{
    double t = pMean; 
    pMean = x;
    return t;
}

CNNegExp::CNNegExp()
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}

CNNegExp::CNNegExp(CNParam *) 
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}



double CNNegExp::operator()()
{
    return(-pMean * log(pGenerator -> as_double()));
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNNegExp::print(ostream &strm) const
{
    strm << "mean=" << pMean << endl;
}

// Debug output
void CNNegExp::dump(ostream &strm) const
{
    strm << "CNNegExp { "
	 << "mean=" << pMean
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNNegExp
static CNClass CNNegExp_desc("CNNegExp", "$Revision: 0.30 $", CNNegExp::new_object);

// "Type" for type checking functions
CNClassDesc CN_NEGEXP = &CNNegExp_desc;






