//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: RandomMix.c,v 0.30 1996-08-07 18:02:00+02 steppler Exp $
 *
 * CNClass: CNRandomMix --- Mixed distributions
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "RandomMix.h"




CNRandomMix::CNRandomMix(CNRandomMixEntry *address, int length, CNRNG *gen)
    : CNRandom(gen)
{
    adr = address;
    len = length;
}

CNRandomMix::CNRandomMix() : CNRandom((CNRNG*)NIL)
{
    adr = 0;
}

CNRandomMix::CNRandomMix(CNParam *) : CNRandom((CNRNG*)NIL)
{
    adr = 0;
}



double CNRandomMix::operator()()
{
    double tmp = pGenerator->as_double();

    for(int i=0; i<len; i++)
	if(tmp < adr[i].p)
	    return (*adr[i].dist)();

    warning(NIL, "CNRandomMix: inconsistent table");
    return 0;
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNRandomMix::print(ostream &strm) const
{
    strm << "n=" << len << endl;
    for(int i=0; i<len; i++)
	strm << "p=" << adr[i].p << "  " << adr[i].dist->class_desc()->name()
	     << ": " << adr[i].dist << endl;
}

// Debug output
void CNRandomMix::dump(ostream &strm) const
{
    strm << "CNRandomMix { " << endl;
    strm << "n=" << len << endl;
    for(int i=0; i<len; i++)
    {
	strm << "p=" << adr[i].p << "  ";
	adr[i].dist->dump(strm);
    }
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNRandomMix
static CNClass CNRandomMix_desc("CNRandomMix", "$Revision: 0.30 $",
			    CNRandomMix::new_object);

// "Type" for type checking functions
CNClassDesc CN_RANDOMMIX = &CNRandomMix_desc;






