//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: TausG.c,v 0.30 1996-08-07 18:02:17+02 steppler Exp $
 *
 * CNClass: CNTausG --- Tausworth random number generator
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "TausG.h"



CNTausG::CNTausG()
{
    reset();
}



void CNTausG::reset()
{
    reg[0] = 0x01234567;
    reg[1] = 0x89abcdef;
    reg[2] = 0xfedcba98;
    reg[3] = 0x76543210;
    reg[4] = 0xf0f00f0f;
    count = 0;
}



unsigned long CNTausG::as_long32()
{
    if (++count>4) {
        register unsigned long *r = reg;
        register unsigned long *q = r + 1;

        *r ^= (*r >> 31) | (*q << 1);
        *q ^= (*q >> 31) | (*(q + 1) << 1);
        q++;

        *q ^= (*q >> 31) | (*(q + 1) << 1);
        q++;

        *q ^= (*q >> 31) | (*(q + 1) << 1);
        q++;

        *q ^= *r & 0x7fffffff;
        *q &= 0x7fffffff;

        count=0;
    }

    return(reg[count]);
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNTausG::print(ostream &strm) const
{
    for(int i=0; i<5; i++)
    {
	strm.width(8);
	strm << hex << reg[i];
    }
    strm << dec << endl;
}

// Debug output
void CNTausG::dump(ostream &strm) const
{
    strm << "CNTausG { ";
    for(int i=0; i<5; i++)
    {
	strm.width(8);
	strm << hex << reg[i];
    }
    strm << dec << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNTausG
static CNClass CNTausG_desc("CNTausG", "$Revision: 0.30 $",
			  CNTausG::new_object);

// "Type" for type checking functions
CNClassDesc CN_TAUSG = &CNTausG_desc;






