//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Uniform.c,v 0.30 1996-08-07 18:02:20+02 steppler Exp $
 *
 * CNClass: CNUniform --- CNUniform distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include "Uniform.h"



CNUniform::CNUniform(double low, double high, CNRNG *gen)
    : CNRandom(gen)
{
    pLow = (low < high) ? low : high;
    pHigh = (low < high) ? high : low;
    delta = pHigh - pLow;
}

double CNUniform::low() { return pLow; }

double CNUniform::low(double x) {
    double tmp = pLow;
    pLow = x;
    delta = pHigh - pLow;
    return tmp;
}

double CNUniform::high() { return pHigh; }

double CNUniform::high(double x) {
    double tmp = pHigh;
    pHigh = x;
    delta = pHigh - pLow;
    return tmp;
}
CNUniform::CNUniform(CNParam *)
	 : CNRandom((CNRNG*)NIL)
{
     pLow = 0;
     pHigh = 0;
     delta = 0;
}    


CNUniform::CNUniform()
	 : CNRandom((CNRNG*)NIL)
{
    pLow = 0;
    pHigh = 0;
    delta = 0;
}    



double CNUniform::operator()()
{
    return( pLow + delta * pGenerator -> as_double() );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNUniform::print(ostream &strm) const

{
    strm << "low = " << pLow << " high = " << pHigh << " delta = " << delta << endl;
}

// Debug output
void CNUniform::dump(ostream &strm) const
{
    strm << "CNUniform { "
	 << "low = " << pLow << " high = " << pHigh << " delta = " << delta
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNUniform
static CNClass CNUniform_desc("CNUniform", "$Revision: 0.30 $", CNUniform::new_object);


// "Type" for type checking functions
CNClassDesc CN_UNIFORM = &CNUniform_desc;






