//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Weibull.c,v 0.30 1996-08-07 18:02:23+02 steppler Exp $
 *
 * CNClass: CNWeibull --- CNWeibull distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include "Weibull.h"



void CNWeibull::setState() {
    pInvAlpha = 1.0 / pAlpha;
}
    
CNWeibull::CNWeibull(double alpha, double beta,  CNRNG *gen)
    : CNRandom(gen)
{
    pAlpha = alpha;
    pCNBeta = beta;
    setState();
}

CNWeibull::CNWeibull()
	 : CNRandom((CNRNG*)NIL)
{
    pAlpha = 0;
    pInvAlpha = 0;
    pCNBeta = 0;
}    

CNWeibull::CNWeibull(CNParam *)
	 : CNRandom((CNRNG*)NIL)
{
    pAlpha = 0;
    pInvAlpha = 0;
    pCNBeta = 0;
}    

double CNWeibull::alpha() { return pAlpha; }

double CNWeibull::alpha(double x) {
    double tmp = pAlpha;
    pAlpha = x;
    setState();
    return tmp;
}

double CNWeibull::beta() { return pCNBeta; };

double CNWeibull::beta(double x) {
    double tmp = pCNBeta;
    pCNBeta = x;
    return tmp;
};


double CNWeibull::operator()()
{
    return( pow(pCNBeta * ( - log(1 - pGenerator -> as_double()) ), pInvAlpha) );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNWeibull::print(ostream &strm) const
{
    strm << "alpha = " << pAlpha << " (inv.alpha = " << pInvAlpha << ") "
	 << "beta = " << pCNBeta << endl;
}

// Debug output
void CNWeibull::dump(ostream &strm) const
{
    strm << "CNWeibull { "
	 << "alpha = " << pAlpha << " (inv.alpha = " << pInvAlpha << ") "
	 << "beta = " << pCNBeta
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNWeibull
static CNClass CNWeibull_desc("CNWeibull", "$Revision: 0.30 $", CNWeibull::new_object);

// "Type" for type checking functions
CNClassDesc CN_WEIBULL = &CNWeibull_desc;






