//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Confidence.c,v 1.2 1996-08-07 18:02:48+02 steppler Exp $
 *
 * CNClass: CNConfidence --- Simple stat. evaluation: mean, variance,
 * 			     skewness etc.
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Confidence.h"

#include <math.h>
#include <limits.h>
#include <float.h>

struct CNConfidence::ez_level
CNConfidence::level[] =  {
    {0.0, 0.0},    
    {.01, .00398935631463160370178999790847},{.02, .00797831371690198102632775970595},
    {.03, .0119664734141126446388791040653}, {.04, .0159534368528307613984263088939},
    {.05, .0199388058383724615963214717727}, {.06, .0239221826541068439636820826938},
    {.07, .0279031701805211035884368162219}, {.08, .0318813720139873769867964945409},
    {.09, .0358563925851721071717488756781}, {.1, .0398278372770289814654046182392},
    {.11, .0437953125423167857880474670426}, {.12, .0477584260205838509631468854821},
    {.13, .0517167866545611389064360466615}, {.14, .0556700048059064290843067965840},
    {.15, .0596176923702425179622614053840}, {.16, .0635594628914328359126006089895},
    {.17, .0674949316750384167715511235550}, {.18, .0714237159009007244547784949265},
    {.19, .0753454347347954482478496115270}, {.2, .0792597094391030230424379529565},
    {.21, .0831661634824423123148077166215}, {.22, .0870644226482146094330709782890},
    {.23, .0909541151420058662950435530130}, {.24, .0948348716977958466695415890180},
    {.25, .0987063256829237242408537915810}, {.26, .102568113201760501509724618266},
    {.27, .106419873198039514626752188621}, {.28, .110261247555797210140150232917},
    {.29, .114091881198877331716952425677}, {.3, .117911422188952637306528963122},
    {.31, .121719521822019279094193295160}, {.32, .125515834723320019052958052587},
    {.33, .129300018940653521032164075847}, {.34, .133071736036028055189494367424},
    {.35, .136830651175619071223259952428}, {.36, .140576433217991242320012775231},
    {.37, .144308754800546751004484960270}, {.38, .148027292424162780152388095589},
    {.39, .151731726535982386272445914702}, {.4, .155421741610324166736880676022},
    {.41, .159097026227677386879215277205}, {.42, .162757273151750505710674791941},
    {.43, .166402179404542329344978070867}, {.44, .170031446339406327967660513308},
    {.45, .173644779712079974231614959231}, {.46, .177241889749652297187372166829},
    {.47, .180822491217444195138753548479}, {.48, .184386303483777412018956888930},
    {.49, .187933050582609453870133080852}, {.5, .191462461274013103637704610609},
    {.51, .194974269102480582612225813142}, {.52, .198468212453033804317346962791},
    {.53, .201944034605123570302127267168}, {.54, .205401483784301965999258813020},
    {.55, .208840313211653627408579583796}, {.56, .212260281150972964710726325927},
    {.57, .215661150953675845865489225044}, {.58, .219042691101435660664508930486},
    {.59, .222404675246535102455189845573}, {.6, .225746882249926419705637214931},
    {.61, .229069096216994301620448938341}, {.62, .232371106531016970034611369153},
    {.63, .235652707884322452707838022939}, {.64, .238913700307138409825737479080},
    {.65, .242153889194135274910518644295}, {.66, .245373085328663852388886595534},
    {.67, .248571104904689885708711830329}, {.68, .251747769546429471104303690851},
    {.69, .254902906325690541863928328326}, {.7, .258036347776926985250649571828},
    {.71, .261147931910013278084417108759}, {.72, .264237502220748836443937326663},
    {.73, .267304907699102569045010264501}, {.74, .270350002835209401671700317315},
    {.75, .273372647623131800672937830617}, {.76, .276372707562400566106698087946},
    {.77, .279350053657350388756039357329}, {.78, .282304562414266869118456027201},
    {.79, .285236115836362879768523031438}, {.8, .288144601416603314424468228229},
    {.81, .291029912128398406847995694358}, {.82, .293891946414186919634942732100},
    {.83, .296730608171931596299935298566}, {.84, .299545806739550339135565724465},
    {.85, .302337456877307619477387375020}, {.86, .305105478748191645599455993270},
    {.87, .307849797896303805898523118212}, {.88, .310570345223287870723974356154},
    {.89, .313267056962827374629607645128}, {.9, .315939874653240511445802199119},
    {.91, .318588745108202756909279279134}, {.92, .321213620385628287184780730981},
    {.93, .323814457754742086040607277712}, {.94, .326391219661375428299985793307},
    {.95, .328943873691518192114627470836}, {.96, .331472392533162187257682768748},
    {.97, .333976753936470390702875078001}, {.98, .336456940672307653967408732061},
    {.99, .338912940489169088801024936025}, {1., .341344746068542948585232545632},
    {1.01, .343752354978745402078295631013}, {1.02, .346135769627265143746056136029},
    {1.03, .348494997211656300729027363566}, {1.04, .350830049669018580415047170813},
    {1.05, .353140943624104054546282522675}, {1.06, .355427700336090395750976289579},
    {1.07, .357690345644060770344506747720}, {1.08, .359928909911230947210325822162},
    {1.09, .362143427967964506596827469440}, {1.1, .364333939053617324826942961974},
    {1.11, .366500486757252771316763116284}, {1.12, .368643118957269283068579007451},
    {1.13, .370761887759982179100154162610}, {1.14, .372856849437201743279999860019},
    {1.15, .374928064362849738968123660949}, {1.16, .376975596948656622948864432910},
    {1.17, .378999515578981799647705887746}, {1.18, .380999892544799299832514851021},
    {1.19, .382976803976891281220510511010}, {1.2, .384930329778291731977779793044},
    {1.21, .386860553556022712363370496102}, {1.22, .388767562552165395112077444371},
    {1.23, .390651447574308061967616038393}, {1.24, .392512302925413082490401456353},
    {1.25, .394350226333144742311227235974}, {1.26, .396165318878699601842851279526},
    {1.27, .397957684925180853573727516312}, {1.28, .399727432045557906947831697201},
    {1.29, .401474670950252164995057447661}, {1.3, .403199515414389666847990175698},
    {1.31, .404902082204760955608903777482}, {1.32, .406582491006528192276644378043},
    {1.33, .408240864349719174182167771619}, {1.34, .409877327535547531203053906085},
    {1.35, .411492008562597965533413270082}, {1.36, .413085038052914971590451636826},
    {1.37, .414656549178033022368173056003}, {1.38, .416206677584985737838483992595},
    {1.39, .417735561322331060496355790829}, {1.4, .419243340766228953503811369366},
    {1.41, .420730158546607608770717802232}, {1.42, .422196159473453606389600432535},
    {1.43, .423641490463260903794607769179}, {1.44, .425066300465672953524995752637},
    {1.45, .426470740390351653229934523594}, {1.46, .427854963034106221247406869197},
    {1.47, .429219123008314466422517258930}, {1.48, .430563376666668282499687552510},
    {1.49, .431887882033274546131238234093}, {1.5, .433192798731141933995505959021},
    {1.51, .434478287911083499415478013506}, {1.52, .435744512181064162918555187874},
    {1.53, .436991635536021575083483807115}, {1.54, .438219823288188104484407067926},
    {1.55, .439429241997940989265063888561}, {1.56, .440620059405206968556439687622},
    {1.57, .441792444361446980283365569282}, {1.58, .442946566762245775580436817660},
    {1.59, .444082597480530557741368321543}, {1.6, .445200708300442006039526033426},
    {1.61, .446301071851880292556088975714}, {1.62, .447383861545747944004961149761},
    {1.63, .448449251509910641112094441552}, {1.64, .449497416525896286045753654730},
    {1.65, .450528531966351904349897243195}, {1.66, .451542773733277182443184873088},
    {1.67, .452540318197052675640060318641}, {1.68, .453521342136279955447303256438},
    {1.69, .454486022678450199198846558372}, {1.7, .455434537241456960512566995293},
    {1.71, .456367063475968096173403311251}, {1.72, .457283779208671064444533943972},
    {1.73, .458184862386405052047839701450}, {1.74, .459070491021192632689884755076},
    {1.75, .459940843136182909581242650114}, {1.76, .460796096712517348433584334600},
    {1.77, .461636429637128766435976312854}, {1.78, .462462019651483207211495136017},
    {1.79, .463273044301273702226207684549}, {1.8, .464069680887074196039674138558},
    {1.81, .464852106415961196610270512939}, {1.82, .465620497554110003046445432301},
    {1.83, .466375030580371662158750524140}, {1.84, .467115881340836112334754304959},
    {1.85, .467843225204386289032659379750}, {1.86, .468557237019247290957604395444},
    {1.87, .469258091070534040120258732085}, {1.88, .469945961038800212838324569506},
    {1.89, .470621019959590572670684020495}, {1.9, .471283440183998200598663035836},
    {1.91, .471933393340227492801436526447}, {1.92, .472571050296163182409863995919},
    {1.93, .473196581122945038946590544724}, {1.94, .473810155059547308036324737198},
    {1.95, .474411940478361374649767654681}, {1.96, .475002104851779565863415730960},
    {1.97, .475580814719777454095892190946}, {1.98, .476148235658491479224946564258},
    {1.99, .476704532249788178088123079117}, {2., .477249868051820792799717362834},
    {2.01, .477784405570568525237568635686}, {2.02, .478308306232353214111323414934},
    {2.03, .478821730357327733350350981639}, {2.04, .479324837133929946261382649030},
    {2.05, .479817784594295599105844188193}, {2.06, .480300729590623100523357642483},
    {2.07, .480773827772482709655747206270}, {2.08, .481237233565062245966177048560},
    {2.09, .481691100148341037648415299207}, {2.1, .482135579437183443216075759802},
    {2.11, .482570822062342912372468806647}, {2.12, .482996977352367197597084201290},
    {2.13, .483414193316394987040929567080}, {2.14, .483822616627833902283928104627},
    {2.15, .484222392608909491245345988150}, {2.16, .484613665216074547013097626167},
    {2.17, .484996577026267797518688126871}, {2.18, .485371269224010738769307820722},
    {2.19, .485737881589331125684188570789}, {2.2, .486096552486501389385246123105},
    {2.21, .486447418853580017968538707244}, {2.22, .486790616192743719229543623831},
    {2.23, .487126278561397978418482060130}, {2.24, .487454538564053431739435131004},
    {2.25, .487775527344955296847376068701}, {2.26, .488089374581452934900461666071},
    {2.27, .488396208478096464642656585474}, {2.28, .488696155761447207367720716466},
    {2.29, .488989341675588612285853908607}, {2.3, .489275889978324194607644516137},
    {2.31, .489555922938048913398219251564}, {2.32, .489829561331280322752815313189},
    {2.33, .490096924440835747912259231885}, {2.34, .490358130054641667375933196368},
    {2.35, .490613294465161422677986888945}, {2.36, .490862532469427329061743260823},
    {2.37, .491105957369663222604393428802}, {2.38, .491343680974483452191458247627},
    {2.39, .491575813600654307896049969876}, {2.4, .491802464075403870555613059679},
    {2.41, .492023739739266270428770238874}, {2.42, .492239746449446355523968482371},
    {2.43, .492450588583690792283548736114}, {2.44, .492656369044651652542615819424},
    {2.45, .492857189264728580820150631499}, {2.46, .493053149211375684796498124710},
    {2.47, .493244347392859349041110183249}, {2.48, .493430880864453237430054758173},
    {2.49, .493612845235056822985839584901}, {2.5, .493790334674223864833021895426},
    {2.51, .493963441919587340341600740735}, {2.52, .494132258284667436075532303854},
    {2.53, .494296873667049303624847647506}, {2.54, .494457376556917395525777493971},
    {2.55, .494613854045933312013252243329}, {2.56, .494766391836444211053902574747},
    {2.57, .494915074251008961725729054480}, {2.58, .495059984242229354294395937951},
    {2.59, .495201203402873819038279145229}, {2.6, .495338811976281249749006590771},
    {2.61, .495472888867032676636924608181}, {2.62, .495603511651878686859170193040},
    {2.63, .495730756590910648821290876371}, {2.64, .495854698638963958543286956202},
    {2.65, .495975411457241692491577585799}, {2.66, .496092967425147221126276304158},
    {2.67, .496207437652314510767571818974}, {2.68, .496318891990825018018078137902},
    {2.69, .496427399047600260664890061009}, {2.7, .496533026196959331504058173120},
    {2.71, .496635839593330806662877585102}, {2.72, .496735904184108687526784791005},
    {2.73, .496833283722642205096339346394}, {2.74, .496928040781349507297952911668},
    {2.75, .497020236764945443245705753014}, {2.76, .497109931923773853500616101806},
    {2.77, .497197185367234971801918747629}, {2.78, .497282055077298741360132847217},
    {2.79, .497364597922095047415951663678}, {2.8, .497444869669572067198468639208},
    {2.81, .497522925001214138481435278487}, {2.82, .497598817525810748461928599765},
    {2.83, .497672599793268445501177049573}, {2.84, .497744323308457677205975454146},
    {2.85, .497814038545086759229209561170}, {2.86, .497881794959595379872118907310},
    {2.87, .497947641005060245926205317388}, {2.88, .498011624145105675050862169633},
    {2.89, .498073790867812139200160962370}, {2.9, .498134186699615962049689715135},
    {2.91, .498192856219193570897401972520}, {2.92, .498249843071323899991224600328},
    {2.93, .498305189980722737545413042366}, {2.94, .498358938765843002726659727318},
    {2.95, .498411130352635131503667887917}, {2.96, .498461804788261941348782996148},
    {2.97, .498511001254762534250360760454}, {2.98, .498558758082659985237401705568},
    {2.99, .498605112764507749535649710649}, {3., .498650101968369905473348185233},
    {3.01, .498693761551230532246108651529}, {3.02, .498736126572327701549190127619},
    {3.03, .498777231306407739811568740869}, {3.04, .498817109256895593243439253206},
    {3.05, .498855793168977301065414983088}, {3.06, .498893315042590753056044333520},
    {3.07, .498929706145321075870830782408}, {3.08, .498964997025197158391284221703},
    {3.09, .498999217523385989601203082573}, {3.1, .499032396786781643107884328076},
    {3.11, .499064563280485900380647589313}, {3.12, .499095744800177660024106097790},
    {3.13, .499125968484368432898914709851}, {3.14, .499155260826541372611823177741},
    {3.15, .499183647687171437786889398027}, {3.16, .499211154305624426571293824860},
    {3.17, .499237805311932764996398061248}, {3.18, .499263624738446069084908009819},
    {3.19, .499288636031354635948898921818}, {3.2, .499312862062084151544882296411},
    {3.21, .499336325138560032227988176361}, {3.22, .499359047016339943767661994441},
    {3.23, .499381048909613165044925279903}, {3.24, .499402351502065584241963514503},
    {3.25, .499422974957609232957083080686}, {3.26, .499442938930975378333099498911},
    {3.27, .499462262578170304978748327507}, {3.28, .499480964566793027197020128485},
    {3.29, .499499063086214277820102559466}, {3.3, .499516575857616222798889891871},
    {3.31, .499533520143892450619064771885}, {3.32, .499549912759407882631003119012},
    {3.33, .499565770079618344504712827172}, {3.34, .499581108050549630273196102468},
    {3.35, .499595942198135978829439424205}, {3.36, .499610287637417968316926658702},
    {3.37, .499624159081599916626126688543}, {3.38, .499637570850966956206476901991},
    {3.39, .499650536881662028653200170167}, {3.4, .499663070734323119060590236456},
    {3.41, .499675185602581121979337293291}, {3.42, .499686894321418800007546615751},
    {3.43, .499698209375391362617102736506}, {3.44, .499709142906709256803918251893},
    {3.45, .499719706723183822588468429010}, {3.46, .499729912306036525318985925902},
    {3.47, .499739770817572533181885227152}, {3.48, .499749293108719462341420165060},
    {3.49, .499758489726432163753102846914}, {3.5, .499767370920964474963650074114},
    {3.51, .499775946653008907165498484582}, {3.52, .499784226600705282458205160418},
    {3.53, .499792220166519378724864714551}, {3.54, .499799936483992679802079234552},
    {3.55, .499807384424364366750520257177}, {3.56, .499814572603066722063624159718},
    {3.57, .499821509386095152628704839132}, {3.58, .499828202896254069222274849590},
    {3.59, .499834661019279890324392933547}, {3.6, .499840891409842466120334902904},
    {3.61, .499846901497426244766876689836}, {3.62, .499852698492092527380122739941},
    {3.63, .499858289390124180797281367720}, {3.64, .499863680979554198021239308031},
    {3.65, .499868879845579515419321144818}, {3.66, .499873892375861513261236582657},
    {3.67, .499878724765714642090780328093}, {3.68, .499883383023184631776036962932},
    {3.69, .499887872974017752918121055004}, {3.7, .499892200266522611663062530567},
    {3.71, .499896370376325968899253577608}, {3.72, .499900388611024083377510691696},
    {3.73, .499904260114731085505527346736}, {3.74, .499907989872525894486171631561},
    {3.75, .499911582714799196132182245331}, {3.76, .499915043321502002140362625916},
    {3.77, .499918376226297313887932392784}, {3.78, .499921585820616414963348031478},
    {3.79, .499924676357621316704223211152}, {3.8, .499927651956074880026006587427},
    {3.81, .499930516604120134826305752058}, {3.82, .499933274162970315280107075471},
    {3.83, .499935928370511125438974846745}, {3.84, .499938482844816744750361082559},
    {3.85, .499940941087581077458546127539}, {3.86, .499943306487465743372957435515},
    {3.87, .499945582323366300228536390822}, {3.88, .499947771767598179851645191922},
    {3.89, .499949877889003811618269943251}, {3.9, .499951903655982397282853292477},
    {3.91, .499953851939443791199172281564}, {3.92, .499955725515687929281770743419},
    {3.93, .499957527069211238799375039228}, {3.94, .499959259195441449281585060149},
    {3.95, .499960924403402212487356534904}, {3.96, .499962525118308926558089540551},
    {3.97, .499964063684097146188519722247}, {3.98, .499965542365884946923374055548},
    {3.99, .499966963352370597554495448585}, {4., .499968328758166880078746229244},
    {4.01, .499969640626073381807649506210}, {4.02, .499970900929288069020894962894},
    {4.03, .499972111573559436052295234110}, {4.04, .499973274399280507912605092873},
    {4.05, .499974391183525958512187515621}, {4.06, .499975463642033590270516729034},
    {4.07, .499976493431131404410951071254}, {4.08, .499977482149611474559409959034},
    {4.09, .499978431340551819415196988588}, {4.1, .499979342493087453261204745541},
    {4.11, .499980217044131775948434713012}, {4.12, .499981056380049446744832492961},
    {4.13, .499981861838281869098893216169}, {4.14, .499982634708926395951715575224},
    {4.15, .499983376236270347753927208566}, {4.16, .499984087620280917822300663841},
    {4.17, .499984770018052022120448159126}, {4.18, .499985424545209132983643401717},
    {4.19, .499986052277273118743896384313}, {4.2, .499986654250984093661646907882},
    {4.21, .499987231465586265048017308194}, {4.22, .499987784884074746979085793779},
    {4.23, .499988315434405292573169396206}, {4.24, .499988824010667879435160141373},
    {4.25, .499989311474225065579530799442}, {4.26, .499989778654816015936190364835},
    {4.27, .499990226351627082430890046641}, {4.28, .499990655334329803623827886675},
    {4.29, .499991066344087172995459389981}, {4.3, .499991460094529008195804645750},
    {4.31, .499991837272697236930799263077}, {4.32, .499992198539961898654066392199},
    {4.33, .499992544532908644872050307603}, {4.34, .499992875864198504661480859315},
    {4.35, .499993193123400665946948495826}, {4.36, .499993496877799007198872392410},
    {4.37, .499993787673173098493856572622}, {4.38, .499994066034554375335485352811},
    {4.39, .499994332466958173268773191661}, {4.4, .499994587456092296140158079028},
    {4.41, .499994831469042775861165732762}, {4.42, .499995064954937466731389595011},
    {4.43, .499995288345588102768616988092}, {4.44, .499995502056111432083856131150},
    {4.45, .499995706485530028129447225918}, {4.46, .499995902017353363641843025443},
    {4.47, .499996089020139719299204413730}, {4.48, .499996267848039485519583633814},
    {4.49, .499996438841320402439805924448}, {4.5, .499996602326875269939598312551},
    {4.51, .499996758618712646611195591219}, {4.52, .499996908018431043822485689382},
    {4.53, .499997050815677108482420894807}, {4.54, .499997187288588275791381752847},
    {4.55, .499997317704220361146692875621}, {4.56, .499997442318960548474611131834},
    {4.57, .499997561378926220574703070641}, {4.58, .499997675120350065590284386753},
    {4.59, .499997783769951882459020644611}, {4.6, .499997887545297497150230875673},
    {4.61, .499997986655145190659082210395}, {4.62, .499998081299780029101753015547},
    {4.63, .499998171671336475838670752389}, {4.64, .499998257954109655343861122255},
    {4.65, .499998340324855628535911932833}, {4.66, .499998418953081029488573204395},
    {4.67, .499998494001322403844985704620}, {4.68, .499998565625415579867248056872},
    {4.69, .499998633974755393860692343995}, {4.7, .499998699192546082717940398043},
    {4.71, .499998761416042647529570651757}, {4.72, .499998820776783483603969647612},
    {4.73, .499998877400814563826528117461}, {4.74, .499998931408905454065553539667},
    {4.75, .499998982916757431296828740818}, {4.76, .499999032035203967268309050780},
    {4.77, .499999078870403832858623523820}, {4.78, .499999123524027070795383618336},
    {4.79, .499999166093434077089315025664}, {4.8, .499999206671848024405383852962},
    {4.81, .499999245348520853629819512593}, {4.82, .499999282208893053099643682767},
    {4.83, .499999317334747438336369666596}, {4.84, .499999350804357138665287206715},
    {4.85, .499999382692627990803521584182}, {4.86, .499999413071235533361162945827},
    {4.87, .499999442008756790217499016762}, {4.88, .499999469570797024906038144468},
    {4.89, .499999495820111642464859327855}, {4.9, .499999520816723409680146701607},
    {4.91, .499999544618035159267831773840}, {4.92, .499999567278938138298352884596},
    {4.93, .499999588851916156069927215608}, {4.94, .499999609387145681673702074239},
    {4.95, .499999628932592036667003755695}, {4.96, .499999647534101823575939757813},
    {4.97, .499999665235491726383152322934}, {4.98, .499999682078633814717902178311},
    {4.99, .499999698103537479151231906122}, {5., .499999713348428120806088326248},
    {5.01, .499999727849822714418362773120}, {5.02, .499999741642602360027249326975},
    {5.03, .499999754760081934629559493970}, {5.04, .499999767234076951400127895651},
    {5.05, .499999779094967730456683674583}, {5.06, .499999790371760981630060250006},
    {5.07, .499999801092148896286913810292}, {5.08, .499999811282565841939789906968},
    {5.09, .499999820968242750166019399637}, {5.1, .499999830173259285240172606208},
    {5.11, .499999838920593877862318559789}, {5.12, .499999847232171705433822093848},
    {5.13, .499999855128910697491595644993}, {5.14, .499999862630765642158369561150},
    {5.15, .499999869756770466798453025429}, {5.16, .499999876525078763483460896640},
    {5.17, .499999882953002627368448401062}, {5.18, .499999889057049873653729717160},
    {5.19, .499999894852959696459297830764}, {5.2, .499999900355736830665187301584},
    {5.21, .499999905579684275570340583390}, {5.22, .499999910538434637092600323783},
    {5.23, .499999915244980143171438989093}, {5.24, .499999919711701385041073913028},
    {5.25, .499999923950394835112857488540}, {5.26, .499999927972299190340472036295},
    {5.27, .499999931788120588137726424592}, {5.28, .499999935408056740174912411495},
    {5.29, .499999938841820027694034499933}, {5.3, .499999942098659600354115172946},
    {5.31, .499999945187382519043570594480}, {5.32, .499999948116373981575758422737},
    {5.33, .499999950893616668714662543608}, {5.34, .499999953526709246558777313610},
    {5.35, .499999956022884059941098785809}, {5.36, .499999958389024050180268987190},
    {5.37, .499999960631678929240932009090}, {5.38, .499999962757080641128861261877},
    {5.39, .499999964771158140157052555687}, {5.4, .499999966679551514571427152244},
    {5.41, .499999968487625482917764252900}, {5.42, .499999970200482289463726995469},
    {5.43, .499999971822974023960134725116}, {5.44, .499999973359714390032772778691},
    {5.45, .499999974815089945538855413428}, {5.46, .499999976193270837299633927996},
    {5.47, .499999977498221051731466072615}, {5.48, .499999978733708202040859147579},
    {5.49, .499999979903312871823520897950}, {5.5, .499999981010437534112280616149},
    {5.51, .499999982058315064152886495189}, {5.52, .499999983050016863449180008635},
    {5.53, .499999983988460611909056245868}, {5.54, .499999984876417664239029059126},
    {5.55, .499999985716520106077245473203}, {5.56, .499999986511267484721573991579},
    {5.57, .499999987263033228700089652681}, {5.58, .499999987974070769845082418690},
    {5.59, .499999988646519380967835709967}, {5.6, .499999989282409741689092645039},
    {5.61, .499999989883669244458605346788}, {5.62, .499999990452127052295726096245},
    {5.63, .499999990989518919300948258887}, {5.64, .499999991497491784524960925939},
    {5.65, .499999991977608149336485820764}, {5.66, .499999992431350248002280018252},
    {5.67, .499999992860124020781594823301}, {5.68, .499999993265262898442480302284},
    {5.69, .499999993648031406728035682729}, {5.7, .499999994009628598936465570166},
    {5.71, .499999994351191324429065877686}, {5.72, .499999994673797340544504037206},
    {5.73, .499999994978468275075464848014}, {5.74, .499999995266172446154412040965},
    {5.75, .499999995537827546098388126931}, {5.76, .499999995794303195477978772982},
    {5.77, .499999996036423373402355396985}, {5.78, .499999996264968729750248240631},
    {5.79, .499999996480678784825373582430}, {5.8, .499999996684254021673838661974},
    {5.81, .499999996876357876069985559036}, {5.82, .499999997057618628955633158355},
    {5.83, .499999997228631205905369710412}, {5.84, .499999997389958887987085106787},
    {5.85, .499999997542134938191971662396}, {5.86, .499999997685664147421436522066},
    {5.87, .499999997821024303839440776332}, {5.88, .499999997948667589227404039923},
    {5.89, .499999998069021905814693413541}, {5.9, .499999998182492136900567628638},
    {5.91, .499999998289461344432996080267}, {5.92, .499999998390291906565753491542},
    {5.93, .499999998485326598077348723549}, {5.94, .499999998574889616403434542954},
    {5.95, .499999998659287555908126693157}, {5.96, .499999998738810332898906721289},
    {5.97, .499999998813732063774273387721}, {5.98, .499999998884311898582829912894},
    {5.99, .499999998950794812166844415305}, {6., .499999999013412354962301859299},
    {6.01, .499999999072383365430888188018}, {6.02, .499999999127914646007028682776},
    {6.03, .499999999180201604354867439456}, {6.04, .499999999229428861645754289064},
    {6.05, .499999999275770829486237025100}, {6.06, .499999999319392257049584139078},
    {6.07, .499999999360448749890336094657}, {6.08, .499999999399087261851156956968},
    {6.09, .499999999435446561404193984783}, {6.1, .499999999469657673705117026267},
    {6.11, .499999999501844299576873873619}, {6.12, .499999999532123212581838788299},
    {6.13, .499999999560604635285330712166}, {6.14, .499999999587392595760321410216},
    {6.15, .499999999612585265332432635591}, {6.16, .499999999636275278515930402710},
    {6.17, .499999999658550036045262827144}, {6.18, .499999999679491991862659009164},
    {6.19, .499999999699178924880317264276}, {6.2, .499999999717684196295672553035},
    {6.21, .499999999735076993200059763997}, {6.22, .499999999751422559184699569312},
    {6.23, .499999999766782412613248267117}, {6.24, .499999999781214553197096941639},
    {6.25, .499999999794773657478106111838}, {6.26, .499999999807511263793450494399},
    {6.27, .499999999819475947268658147128}, {6.28, .499999999830713485357695423439},
    {6.29, .499999999841267014423012860203}, {6.3, .499999999851177177823768903868},
    {6.31, .499999999860482265956932280529}, {6.32, .499999999869218348673576229110},
    {6.33, .499999999877419400471367413899}, {6.34, .499999999885117418843969970629},
    {6.35, .499999999892342536148783778393}, {6.36, .499999999899123125336070665284},
    {6.37, .499999999905485899865049765376}, {6.38, .499999999911456008115922426617},
    {6.39, .499999999917057122590978489427}, {6.4, .499999999922311524182901695915},
    {6.41, .499999999927240181774096378700}, {6.42, .499999999931862827417265925306},
    {6.43, .499999999936198027334552844726}, {6.44, .499999999940263248960269056973},
    {6.45, .499999999944074924240573159368}, {6.46, .499999999947648509392360107816},
    {6.47, .499999999950998541313090482697}, {6.48, .499999999954138690823275012214},
    {6.49, .499999999957081812913820204093}, {6.5, .499999999959839994161408821917},
    {6.51, .499999999962424597466511649066}, {6.52, .499999999964846304260482661898},
    {6.53, .499999999967115154320457527238}, {6.54, .499999999969240583323435341121},
    {6.55, .499999999971231458263956739495}, {6.56, .499999999973096110853179811831},
    {6.57, .499999999974842369010881343918}, {6.58, .499999999976477586555958312675},
    {6.59, .499999999978008671195357523589}, {6.6, .499999999979442110906004820324},
    {6.61, .499999999980783998799225104917}, {6.62, .499999999982040056552326852404},
    {6.63, .499999999983215656487456891217}, {6.64, .499999999984315842373500566294},
    {6.65, .499999999985345349022697205426}, {6.66, .499999999986308620749749828497},
    {6.67, .499999999987209828757520564679}, {6.68, .499999999988052887509909074213},
    {6.69, .499999999988841470149200695545}, {6.7, .499999999989579023012034806292},
    {6.71, .499999999990268779295173192381}, {6.72, .499999999990913771919434682051},
    {6.73, .499999999991516845637497942824}, {6.74, .499999999992080668428751568595},
    {6.75, .499999999992607742221982177581}, {6.76, .499999999993100412984430328431},
    {6.77, .499999999993560880213604104853}, {6.78, .499999999993991205866215002202},
    {6.79, .499999999994393322756684361096}, {6.8, .499999999994769042455855412492},
    {6.81, .499999999995120062718830682521}, {6.82, .499999999995447974469231974653},
    {6.83, .499999999995754268365645574347}, {6.84, .499999999996040340974564120349},
    {6.85, .499999999996307500572764398933}, {6.86, .499999999996556972600763002472},
    {6.87, .499999999996789904787765419107}, {6.88, .499999999997007371967364951046},
    {6.89, .499999999997210380602152348505}, {6.9, .499999999997399873034361827162},
    {6.91, .499999999997576731478701012506}, {6.92, .499999999997741781772588290202},
    {6.93, .499999999997895796898148158043}, {6.94, .499999999998039500289490739278},
    {6.95, .499999999998173568938023036637}, {6.96, .499999999998298636307804321368},
    {6.97, .499999999998415295072263929120}, {6.98, .499999999998524099682944461931},
    {6.99, .499999999998625568780314874592}, {7., .499999999998720187456114164996},
    {7.01, .499999999998808409376135505738}, {7.02, .499999999998890658771840860573},
    {7.03, .499999999998967332308705730105}, {7.04, .499999999999038800838731060808},
    {7.05, .499999999999105411044123008947}, {7.06, .499999999999167486978729735089},
    {7.07, .499999999999225331513436350581}, {7.08, .499999999999279227691353251780},
    {7.09, .499999999999329439998288136665}, {7.1, .499999999999376215553666842490},
    {7.11, .499999999999419785226761674916}, {7.12, .499999999999460364682797079790},
    {7.13, .499999999999498155363230355099}, {7.14, .499999999999533345404248682327},
    {7.15, .499999999999566110497282192926}, {7.16, .499999999999596614695105244084},
    {7.17, .499999999999625011166883770456}, {7.18, .499999999999651442905324759841},
    {7.19, .499999999999676043388893866168}, {7.2, .499999999999698937201888256252},
    {7.21, .499999999999720240614983357472}, {7.22, .499999999999740062128713636370},
    {7.23, .499999999999758502982198330071}, {7.24, .499999999999775657629282641532},
    {7.25, .499999999999791614184132793057}, {7.26, .499999999999806454838199035453},
    {7.27, .499999999999820256250343783785}, {7.28, .499999999999833089911822071247},
    {7.29, .499999999999845022487698079723}, {7.3, .499999999999856116136184241425},
    {7.31, .499999999999866428807297953378}, {7.32, .499999999999876014522144968798},
    {7.33, .499999999999884923634057708383}, {7.34, .499999999999893203072740770064},
    {7.35, .499999999999900896572504524585}, {7.36, .499999999999908044885600599101},
    {7.37, .499999999999914685981610019629}, {7.38, .499999999999920855233775567760},
    {7.39, .499999999999926585593114283174}, {7.4, .499999999999931907751093799668},
    {7.41, .499999999999936850291607138925}, {7.42, .499999999999941439832934515191},
    {7.43, .499999999999945701160337447899}, {7.44, .499999999999949657349889870980},
    {7.45, .499999999999953329884112809606}, {7.46, .499999999999956738759943418931},
    {7.47, .499999999999959902589535605137}, {7.48, .499999999999962838694357945060},
    {7.49, .499999999999965563193025062575}, {7.5, .499999999999968091083270891038},
    {7.51, .499999999999970436318446241123}, {7.52, .499999999999972611878898698822},
    {7.53, .499999999999974629838570001503}, {7.54, .499999999999976501427124588900},
    {7.55, .499999999999978237087902914220}, {7.56, .499999999999979846531974246832},
    {7.57, .499999999999981338788546025648}, {7.58, .499999999999982722251970259203},
    {7.59, .499999999999984004725571946893}, {7.6, .499999999999985193462509951953},
    {7.61, .499999999999986295203867130636}, {7.62, .499999999999987316214153757269},
    {7.63, .499999999999988262314396328377}, {7.64, .499999999999989138912972630978},
    {7.65, .499999999999989951034343473665}, {7.66, .499999999999990703345821660066},
    {7.67, .499999999999991400182509591324}, {7.68, .499999999999992045570528278521},
    {7.69, .499999999999992643248652490791}, {7.7, .499999999999993196688459226029},
    {7.71, .499999999999993709113089636243}, {7.72, .499999999999994183514717938419},
    {7.73, .499999999999994622670814665919}, {7.74, .499999999999995029159285838032},
    {7.75, .499999999999995405372564221405}, {7.76, .499999999999995753530723803050},
    {7.77, .499999999999996075693683868439}, {7.78, .499999999999996373772564658984},
    {7.79, .499999999999996649540252451669}, {7.8, .499999999999996904641228041305},
    {7.81, .499999999999997140600708995821}, {7.82, .499999999999997358833152681054},
    {7.83, .499999999999997560650163898547}, {7.84, .499999999999997747267848033875},
    {7.85, .499999999999997919813647860616}, {7.86, .499999999999998079332699573924},
    {7.87, .499999999999998226793741226054}, {7.88, .499999999999998363094604493222},
    {7.89, .499999999999998489067318608631}, {7.9, .499999999999998605482853340732},
    {7.91, .499999999999998713055526069868}, {7.92, .499999999999998812447096311948},
    {7.93, .499999999999998904270569446754}, {7.94, .499999999999998989093729923669},
    {7.95, .499999999999999067442422831876}, {7.96, .499999999999999139803601429223},
    {7.97, .499999999999999206628157017607}, {7.98, .499999999999999268333546427509},
    {7.99, .499999999999999325306231324643}, {8., .499999999999999377903942572822},
    {8.01, .499999999999999426457781974195}, {8.02, .499999999999999471274172856881},
    {8.03, .499999999999999512636670186370}, {8.04, .499999999999999550807640137310},
    {8.05, .499999999999999586029818372683}, {8.06, .499999999999999618527755634716},
    {8.07, .499999999999999648509158652944}, {8.08, .499999999999999676166133816772},
    {8.09, .499999999999999701676340539975}, {8.1, .499999999999999725204060760178},
    {8.11, .499999999999999746901190565231}, {8.12, .499999999999999766908159518170},
    {8.13, .499999999999999785354782861166}, {8.14, .499999999999999802361051414500},
    {8.15, .499999999999999818037863647337}, {8.16, .499999999999999832487704081308},
    {8.17, .499999999999999845805271893911}, {8.18, .499999999999999858078063315164},
    {8.19, .499999999999999869386911156335}, {8.2, .499999999999999879806484572642},
    {8.21, .499999999999999889405751941404}, {8.22, .499999999999999898248409532055},
    {8.23, .499999999999999906393278453684}, {8.24, .499999999999999913894672188371},
    {8.25, .499999999999999920802736853575}, {8.26, .499999999999999927163766183445},
    {8.27, .499999999999999933020493076269}, {8.28, .499999999999999938412359422671},
    {8.29, .499999999999999943375765805916}, {8.3, .499999999999999947944302551097},
    {8.31, .499999999999999952148963493521}, {8.32, .499999999999999956018343737677},
    {8.33, .499999999999999959578822586230}, {8.34, .499999999999999962854732733113},
    {8.35, .499999999999999965868516735419}, {8.36, .499999999999999968640871705158},
    {8.37, .499999999999999971190883093492}, {8.38, .499999999999999973536148376519},
    {8.39, .499999999999999975692891392682}, {8.4, .499999999999999977676068027120},
    {8.41, .499999999999999979499463887402}, {8.42, .499999999999999981175784567926},
    {8.43, .499999999999999982716739056440}, {8.44, .499999999999999984133116795518},
    {8.45, .499999999999999985434858874091}, {8.46, .499999999999999986631123789178},
    {8.47, .499999999999999987730348185464}, {8.48, .499999999999999988740302950310},
    {8.49, .499999999999999989668145013832}, {8.5, .499999999999999990520465177797},
    {8.51, .499999999999999991303332273104}, {8.52, .499999999999999992022333923317},
    {8.53, .499999999999999992682614171121}, {8.54, .499999999999999993288908205429},
    {8.55, .499999999999999993845574409150}, {8.56, .499999999999999994356623931185},
    {8.57, .499999999999999994825747971029}, {8.58, .499999999999999995256342950221},
    {8.59, .499999999999999995651533731842}, {8.6, .499999999999999996014195037152},
    {8.61, .499999999999999996346971197251}, {8.62, .499999999999999996652294367265},
    {8.63, .499999999999999996932401320959}, {8.64, .499999999999999997189348934766},
    {8.65, .499999999999999997425028461988}, {8.66, .499999999999999997641178690313},
    {8.67, .499999999999999997839398068703}, {8.68, .499999999999999998021155883213},
    {8.69, .499999999999999998187802555230}, {8.7, .499999999999999998340579130035},
    {8.71, .499999999999999998480626018430}, {8.72, .499999999999999998608991049359},
    {8.73, .499999999999999998726636887067}, {8.74, .499999999999999998834447862192},
    {8.75, .499999999999999998933236262453}, {8.76, .499999999999999999023748125061},
    {8.77, .499999999999999999106668569763}, {8.78, .499999999999999999182626708413},
    {8.79, .499999999999999999252200164246}, {8.8, .499999999999999999315919231407},
    {8.81, .499999999999999999374270703000}, {8.82, .499999999999999999427701393673},
    {8.83, .499999999999999999476621380791}, {8.84, .499999999999999999521406986346},
    {8.85, .499999999999999999562403520069}, {8.86, .499999999999999999599927802586},
    {8.87, .499999999999999999634270486017}, {8.88, .499999999999999999665698188055},
    {8.89, .499999999999999999694455454304}, {8.9, .499999999999999999720766562506},
    {8.91, .499999999999999999744837181231}, {8.92, .499999999999999999766855894592},
    {8.93, .499999999999999999786995603672}, {8.94, .499999999999999999805414814495},
    {8.95, .499999999999999999822258821586}, {8.96, .499999999999999999837660795493},
    {8.97, .499999999999999999851742781939}, {8.98, .499999999999999999864616619694},
    {8.99, .499999999999999999876384783693}, {9., .499999999999999999887141159405},
    {9.01, .499999999999999999896971753981}, {9.02, .499999999999999999905955349274},
    {9.03, .499999999999999999914164101424}, {9.04, .499999999999999999921664091316},
    {9.05, .499999999999999999928515829888}, {9.06, .499999999999999999934774721935},
    {9.07, .499999999999999999940491491789}, {9.08, .499999999999999999945712573949},
    {9.09, .499999999999999999950480471521}, {9.1, .499999999999999999954834085086},
    {9.11, .499999999999999999958809014391}, {9.12, .499999999999999999962437835100},
    {9.13, .499999999999999999965750352625}, {9.14, .499999999999999999968773834913},
    {9.15, .499999999999999999971533225916}, {9.16, .499999999999999999974051341321},
    {9.17, .499999999999999999976349048001}, {9.18, .499999999999999999978445428516},
    {9.19, .499999999999999999980357931905}, {9.2, .499999999999999999982102511880},
    {9.21, .499999999999999999983693753479}, {9.22, .499999999999999999985144989118},
    {9.23, .499999999999999999986468404924}, {9.24, .499999999999999999987675138151},
    {9.25, .499999999999999999988775366409}, {9.26, .499999999999999999989778389405},
    {9.27, .499999999999999999990692703798}, {9.28, .499999999999999999991526071746},
    {9.29, .499999999999999999992285583678}, {9.3, .499999999999999999992977715760},
    {9.31, .499999999999999999993608382502}, {9.32, .499999999999999999994182984922},
    {9.33, .499999999999999999994706454614}, {9.34, .499999999999999999995183294092},
    {9.35, .499999999999999999995617613701}, {9.36, .499999999999999999996013165389},
    {9.37, .499999999999999999996373373607}, {9.38, .499999999999999999996701363577},
    {9.39, .499999999999999999996999987145}, {9.4, .499999999999999999997271846429},
    {9.41, .499999999999999999997519315443}, {9.42, .499999999999999999997744559871},
    {9.43, .499999999999999999997949555149}, {9.44, .499999999999999999998136102990},
    {9.45, .499999999999999999998305846498}, {9.46, .499999999999999999998460283970},
    {9.47, .499999999999999999998600781526}, {9.48, .499999999999999999998728584637},
    {9.49, .499999999999999999998844828665}, {9.5, .499999999999999999998950548493},
    {9.51, .499999999999999999999046687319}, {9.52, .499999999999999999999134104693},
    {9.53, .499999999999999999999213583852}, {9.54, .499999999999999999999285838426},
    {9.55, .499999999999999999999351518555}, {9.56, .499999999999999999999411216478},
    {9.57, .499999999999999999999465471633}, {9.58, .499999999999999999999514775318},
    {9.59, .499999999999999999999559574936}, {9.6, .499999999999999999999600277880},
    {9.61, .499999999999999999999637255069}, {9.62, .499999999999999999999670844182},
    {9.63, .499999999999999999999701352606}, {9.64, .499999999999999999999729060119},
    {9.65, .499999999999999999999754221352}, {9.66, .499999999999999999999777068019},
    {9.67, .499999999999999999999797810960}, {9.68, .499999999999999999999816642005},
    {9.69, .499999999999999999999833735665}, {9.7, .499999999999999999999849250683},
    {9.71, .499999999999999999999863331442}, {9.72, .499999999999999999999876109252},
    {9.73, .499999999999999999999887703521}, {9.74, .499999999999999999999898222821},
    {9.75, .499999999999999999999907765865}, {9.76, .499999999999999999999916422390},
    {9.77, .499999999999999999999924273964}, {9.78, .499999999999999999999931394728},
    {9.79, .499999999999999999999937852057}, {9.8, .499999999999999999999943707177},
    {9.81, .499999999999999999999949015720}, {9.82, .499999999999999999999953828227},
    {9.83, .499999999999999999999958190613}, {9.84, .499999999999999999999962144582},
    {9.85, .499999999999999999999965728012}, {9.86, .499999999999999999999968975304},
    {9.87, .499999999999999999999971917695}, {9.88, .499999999999999999999974583545},
    {9.89, .499999999999999999999976998605}, {9.9, .499999999999999999999979186248},
    {9.91, .499999999999999999999981167692}, {9.92, .499999999999999999999982962191},
    {9.93, .499999999999999999999984587223}, {9.94, .499999999999999999999986058643},
    {9.95, .499999999999999999999987390840}, {9.96, .499999999999999999999988596865},
    {9.97, .499999999999999999999989688558}, {9.98, .499999999999999999999990676661},
    {9.99, .499999999999999999999991570913}, {10., .499999999999999999999992380147}
};

 
CNConfidence::CNConfidence(const char* aName, const char* aDescription)
    : CNStatistics(aName, aDescription),
      sum(0), sqsum(0), cbsum(0), n(0), 
      min_value(DBL_MAX), max_value(-DBL_MAX)
{}

void CNConfidence::put(double x_i)
{
//
// put expects that an Event occured (x_i == 1.) or not (x_i == 0.)
// Since doubles are not to be compared to other doubles by '==',
// a threshold of 0.5 is used to determine whether the Event occured or not  
//
    x_i = (x_i > 0.5) ? 1. : 0.;
    if (x_i > 0.5) { // the event occured !
	sum += 1.;sqsum += 1.;cbsum += 1.;
    }
    else ; // the event didn't occure !
    
    if (x_i > max_value)
	max_value = x_i;
    if (x_i < min_value)
	min_value = x_i;
    n++;
}

void CNConfidence::reset()
{
    n = 0;
    sum = sqsum = cbsum = 0;
    min_value = DBL_MAX;
    max_value = -DBL_MAX;
}

double CNConfidence::mean() const
{
    return n ? (sum / n) : 0. ;
}

double CNConfidence::variance() const
{
    return n > 1 ? (sqsum - sum * sum / n)/(n - 1) : 0. ;
}

double CNConfidence::relative_variance() const
{
    return n <=1 || sum == 0. ? 0. : variance() * n * n / (sum * sum) ;
}

double CNConfidence::M_2() const
{
    return n ? sqsum / n : 0. ;
}

double CNConfidence::M_3() const
{
    return n ? cbsum / n : 0. ; 
}

double CNConfidence::Z_3() const
{
    if (n<3) return 0.;
    return (n * cbsum + sum * (2.0 * sum * sum / n - 3.0 * sqsum)) / (n - 1) /(n - 2);
}

double CNConfidence::skewness() const
{
    if (n < 3) return 0.;

    double var = variance();
    return (var == 0.) ? 0. : Z_3() / (var * sqrt(var));
}

double CNConfidence::deviation() const
{
    return n > 1 ? sqrt(variance()) : 0.;
}
double CNConfidence::relative_deviation() const
{
    double m_1 = mean();
    return n<=1 || m_1 == 0. ?  0. : sqrt(variance()) / mean();
}

double CNConfidence::err_level(double z) const
{
    return 1. -conf_level(z) ;
}

double CNConfidence::conf_level(double z) const
{
    z = z > 0. ? z :-z;
    if (z >= 10.0) return 1.0;
    
    // binary search
    s_ezl *beg, *mid, *end;
     
    long i, len = sizeof(level)/sizeof(s_ezl);

    beg = level;
    mid = &level[len/2];
    end = &level[len-1];
    
    // Binary search
    while(TRUE)
    {

	if (z >= mid->z)
	    beg = mid;
	else
	    end = mid;
      
	i   = end - beg;
	mid = beg + i/2;
      
	if (i == 1)
	    return 2*(beg->conf + (z - beg->z) * (end->conf - beg->conf)/(end->z - beg->z));
    } 

}

double CNConfidence::z_level(double conf) const
{
    if (conf > 1.) return DBL_MAX;
    if (conf < 0.) return 0.;
     
    conf /= 2.;
     

    // binary search
    s_ezl *beg, *mid, *end;
     
    long i, len = sizeof(level)/sizeof(s_ezl);

    beg = level;
    mid = &level[len/2];
    end = &level[len-1];
    
    // Binary search
    while(TRUE)
    {

	if (conf >= mid->conf)
	    beg = mid;
	else
	    end = mid;
      
	i   = end - beg;
	mid = beg + i/2;
      
	if (i == 1)
	  // linear interpolation:
	    return beg->z + (conf - beg->conf) * (end->z - beg->z)/(end->conf - beg->conf);
    } 

}

double CNConfidence::hi_conf_bound(double conf) const
{
    if (n == 0) return 1.;
    double h = mean();
    double z = z_level(conf);
    return .5 * (2 * h * n + z * z + z * sqrt(4 * h * n + z * z - 4 * h * h * n) ) / (n + z * z);
    
}

double CNConfidence::low_conf_bound(double conf) const
{
    if (n == 0) return 0. ;
    
    double h = mean();
    double z = z_level(conf);
    return .5 * (2 * h * n + z * z - z * sqrt(4 * h * n + z * z - 4 * h * h * n) ) / (n + z * z);
    
}


/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNConfidence::print(ostream &strm) const
{
    strm << "Evaluation " << name << " (CNConfidence)" << endl;
    strm << "Trials             : " << n                    << endl;
    strm << "Mean               : " << mean()               << endl;
    strm << "Low Conf. 95% Mean : " << low_conf_bound(0.95) << endl;
    strm << "Hi  Conf. 95% Mean : " << hi_conf_bound(0.95)  << endl;
    strm << "Variance           : " << variance()           << endl;
    strm << "Relative variance  : " << relative_variance()  << endl;
    strm << "Deviation          : " << deviation()          << endl;
    strm << "Relative deviation : " << relative_deviation() << endl;
    strm << "Skewness           : " << skewness()           << endl;
    strm << "Minimum            : " << min()                << endl;
    strm << "Maximum            : " << max()                << endl;
}


// Debug output
void CNConfidence::dump(ostream &strm) const
{
    strm << "CNConfidence { " << endl;
    strm << "name = " << name << endl;
    strm << "sum = " << sum << "  sqsum = " << sqsum
	 << "  cbsum = " << cbsum << endl;
    strm << "n = " << n << "  min_value = " << min_value
	 << "  max_value = " << max_value << endl;
    strm << "Evaluation " << name << " (CNConfidence)" << endl;
    strm << "Trials             : " << n                    << endl;
    strm << "Mean               : " << mean()               << endl;
    strm << "Low Conf. 95% Mean : " << low_conf_bound(0.95) << endl;
    strm << "Hi  Conf. 95% Mean : " << hi_conf_bound(0.95)  << endl;
    strm << "Mean               : " << mean()               << endl;
    strm << "Variance           : " << variance()           << endl;
    strm << "Relative variance  : " << relative_variance()  << endl;
    strm << "Deviation          : " << deviation()          << endl;
    strm << "Relative deviation : " << relative_deviation() << endl;
    strm << "Skewness           : " << skewness()           << endl;
    strm << "Minimum            : " << min()                << endl;
    strm << "Maximum            : " << max()                << endl;
    strm << " }" << endl;
}

/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNConfidence
static CNClass CNConfidence_desc("CNConfidence", "$Revision: 1.2 $",
					CNConfidence::new_object);

// "Type" for type checking functions
CNClassDesc CN_CONFIDENCE = &CNConfidence_desc;






