//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLREP.h,v 0.33 1996-08-07 18:03:02+02 steppler Exp $
 *
 * Class: CNDLREP --- Discrete LRE (LRE III), probability function
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNDLREP_h
#define __CNDLREP_h


#include <CNCL/DLRE.h>		// Base class

extern CNClassDesc CN_DLREP;	// Class CNDLREP description


/*
 * The class CNDLREP
 */

class CNDLREP : public CNDLRE
{
public:	/***** Constructors ******************************************/
   
    CNDLREP(double*, long, double, double = 0.0, 
	    const char* = NIL, const char* = NIL,
	    bool = false, unsigned long = ULONG_MAX);
    CNDLREP(double, double, double, double, double = 0.0, 
	    const char* = NIL, const char* = NIL, 
	    bool = false, unsigned long = ULONG_MAX); 
    CNDLREP(CNParam *) {}
    ~CNDLREP() {}
  
private:
    CNDLREP() {}
  
public:	/***** Public interface **************************************/
    void put( double );
  
    virtual const struct CNDLRE::resultline *get_result( long ); // result line

    virtual void change_error( double );
    
private:
    Phase rtc(); // runtime control
    
private:	/***** Internal private members ******************************/
    bool force_cf;
    
public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_DLREP; }
  
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_DLREP ? TRUE : CNDLRE::is_a(desc); }
  
    static CNDLREP *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLREP *)obj;
#   else
	return (CNDLREP *)( !obj || obj->is_a(CN_DLREP)
			    ? obj : fatal_type(obj->class_desc(), CN_DLREP) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLREP(param) : new CNDLREP; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNDLREP &obj);
ostream &operator << (ostream &strm, const CNDLREP *obj);

#endif /**__CNDLREP_h**/
