//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MomentsTime.h,v 1.3 1996-08-07 18:03:19+02 steppler Exp $
 *
 * Class: CNMomentsTime --- Simple stat. evaluation:
 *                          mean, variance, skewness, etc.
 *                          time-weighted
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNMomentsTime_h
#define __CNMomentsTime_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Statistics.h>		// Base class
#include <CNCL/String.h>
#include <CNCL/SimTime.h>


extern CNClassDesc CN_MOMENTSTIME;	// Class CNMomentsTime description

/*
 * The class CNMomentsTime
 */

class CNMomentsTime : public CNStatistics
{
  public:	/***** Constructors ******************************************/
    CNMomentsTime(const char* aName = NIL,
		  const char* aDescription = NIL);
    CNMomentsTime(CNParam *) {}

  public:	/***** Public interface **************************************/
    virtual void  put(register double x_i, CNSimTime put_time);
    virtual void  put(double x) ; // not used, but base class is abstract
				  // implementation is necessary 
    virtual double mean() const ;
    virtual void reset();
    
    double variance()           const;
    double M_2()                const;
    double M_3()                const;
    double Z_3()                const;
    double relative_variance()  const;
    double deviation()          const;
    double relative_deviation() const;
    double skewness()           const;
     
    virtual unsigned long  trials()  const {return n; } 
    virtual double         max()     const {return max_value; } 
    virtual double         min()     const {return min_value; } 
    virtual bool           end()     const {return FALSE; }
    virtual Phase          state()   const {return ITERATE; }
    virtual Phase          status()  const {return ITERATE; }

  private:	/***** Internal private members ******************************/
    double    sum ;         // Sum of all values time-weighted 
    double    sqsum ;       // Sum of all values ^2 time-weighted 
    double    cbsum ;       // Sum of all values ^3 time-weighted
    long      n ;           // # of values
    double    min_value ;   // Minimum of all values
    double    max_value ;   // Maximum of all values
    CNSimTime prev_time ;   // Time of previous entry
    
  public:      /***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	 //CNClass description
    { return CN_MOMENTSTIME; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_MOMENTSTIME ? TRUE : CNStatistics::is_a(desc); }
        
    static CNMomentsTime *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNMomentsTime *)obj;
#   else
  	return (CNMomentsTime *)( !obj || obj->is_a(CN_MOMENTSTIME)
  	       ? obj : fatal_type(obj->class_desc(), CN_MOMENTSTIME) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL)  // Object creation
    { return param ? new CNMomentsTime(param) : new CNMomentsTime; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

ostream &operator << (ostream &strm, const CNMomentsTime &obj);
ostream &operator << (ostream &strm, const CNMomentsTime *obj);

#endif /**__CNMomentsTime_h**/















