//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_            C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                      N E T W O R K S
 * |_        |_  |_  |_  |_        |_                            C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                  L I B R A R Y
 *
 * $Id: Statistics.h,v 0.32 1996-08-07 18:03:22+02 steppler Exp $
 *
 * CNClass: CNStatistics --- Base class for statistical evaluation
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Statistics_h
#define __Statistics_h


#include <CNCL/CNCL.h>
#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>        // Base class

#include <CNCL/String.h>

extern CNClassDesc CN_STATISTICS;   // CNClass CNStatistics description

/*
 * The class CNStatistics --- abstract base class for stat. evaluation
 */

class CNStatistics : public CNObject
{
  public:
    enum Phase { INITIALIZE = 0, ITERATE, END };
    enum Type  { DF         = 0, CDF,     PF };

    virtual void          put(double val)   = 0; // Input value
    virtual double        mean()      const = 0; // Return mean value
    virtual double        variance()  const = 0; // Return variance
    virtual unsigned long trials()    const = 0; // Return number of trials
    virtual double        min()       const = 0; // maximal value of trials
    virtual double        max()       const = 0; // minimal     - " -
    virtual void          reset()           = 0; // Reset evaluation
    virtual bool          end()       const = 0; // end of evaluation 
                                                 // reached ?
    virtual Phase         status()    const = 0; // Return state 
                                                 // of evaluation
    const char*           get_name()  const;     // Name of evaluator
    const char*           get_desc()  const;     // Description of evaluator

    /***** Constructors ******************************************************/
  public:
    // Default constructor
    CNStatistics(const char* aName = NIL,
		 const char* aDescription = NIL);
    // CNParam constructor
    CNStatistics(CNParam *);

  protected:
    CNString name;
    CNString text;
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const  // CNClass description
    {
        return CN_STATISTICS;
    };
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
        return desc == CN_STATISTICS ? TRUE : CNObject::is_a(desc);
    };
        
    static CNStatistics *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNStatistics *)obj;
#   else
        return (CNStatistics *)( obj->is_a(CN_STATISTICS)
				 ? obj : fatal_type(obj->class_desc(),
						    CN_STATISTICS) );
#   endif
    }
};

// inlines
inline const char* CNStatistics::get_name() const
{
    return name;
}
inline const char* CNStatistics::get_desc() const
{
    return text;
}

#endif /**__Statistics_h**/
