//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Pipe.h,v 0.30 1996-08-07 18:03:31+02 steppler Exp $
 *
 * Class: CNPipe --- UNIX pipe
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNPipe_h
#define __CNPipe_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Object.h>
#include <CNCL/String.h>

#include <fstream.h>

extern CNClassDesc CN_PIPE;	// Class CNPipe description


/*
 * The class CNPipe
 */

class CNPipe : public CNObject
{
public:
    int open(const CNString& program);  // Open pipe to program
    int close();			// Close pipe

    ostream & out() { return *sout; }	// Output stream
    istream & in () { return *sin;  }	// Input stream

    int fd_in()     { return fdin;  }
    int fd_out()    { return fdout; }

    int get_pid()   { return pid;   }

    // Private members
private:
    int pid;				// PID program
    CNString program;			// Program name
    ifstream *sin;			// Input stream (from program)
    ofstream *sout;			// Output stream (to program)
    int fdin, fdout;			// Pipe file descriptors

    /***** Constructors ******************************************************/
public:
    CNPipe();
    CNPipe(CNParam *param);
    CNPipe(const CNString& prog);
    ~CNPipe()  {    close();	}
    
		    
    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_PIPE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_PIPE ? TRUE : CNObject::is_a(desc);
    };
        
    static CNPipe *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPipe *)obj;
#   else
	return (CNPipe *)( !obj || obj->is_a(CN_PIPE)
	       ? obj : fatal_type(obj->class_desc(), CN_PIPE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNPipe(param) : new CNPipe; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNPipe_h**/
