// Well this is the basic implementation of the object structure of LGE

#ifndef LGE_H
#define LGE_H

#include "visual.h"

#define msg_Nothing     0
#define msg_Destroy     1
#define msg_Refresh     2
#define msg_GotEvent    3
#define msg_Focus       4
#define msg_ReDraw      5
#define msg_Next        6
#define msg_Prev        7

#define GOTFOC          1
#define NOTFOC          2

#define MAXOBJ          63
#define MAXTASK         127

// Abstract class : defines standard behaviour
// All objects that have to be handled by the system must have at least this
// object as ancestor.

class TObject
{
  public:
    TObject *Parent;
    int     Focus;
    int     pX, pY, SizeX, SizeY;
    int     Context;
    int	    Ressource;

    TObject() {};
    virtual ~TObject() {};

    virtual void Draw() {};
    virtual int  HandleEvent(int) { return msg_Nothing; };
    virtual void HandleMsg(int src, int msg, long param1, long param2) {};
    virtual void DoTask() {};
    virtual void GetCoords(int *X, int *Y) {};
    virtual int  GetContext() { return 0; };
    virtual int  GetFocus() { return FALSE; };
    virtual int  GetRessourceID() { return Ressource; };
};

typedef TObject *PObject;

// TDesk is the root object of the interface

class TDesk : public TObject
{
  public:
    PObject Childs[MAXOBJ];
    PObject Tasks[MAXTASK];
    int     NbChilds, NbTask, Running, term;

    TDesk(int res, char *layout);
    virtual ~TDesk();

    virtual void AddTask(PObject task);
    virtual void AddObject(PObject obj);
    virtual void Draw();
    virtual void ActivateTasks();
    virtual void Run();
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();

  private:
    int     ActTask;
    virtual int  HearthBeat();
};

typedef TDesk *PDesk;

class   TWindow;
typedef TWindow *PWindow;

// TClient is a container object for the windows

class TClient : public TObject
{
  public:
    PObject Childs[MAXOBJ];
    int     NbChilds;
    int     Position;
    int     Selector;
    char    *Title;
    PWindow Parent2;

    TClient(int Select, int SelPos, char *title);
    virtual ~TClient() {};

    virtual void AddObject(PObject obj);
    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();
    virtual int  GetFocus();
};

typedef TClient *PClient;

// Menus have to be declared here 'coz windows love them and they want
// to have many children <- joke! hum, forget it...

class   TMenu;
typedef TMenu *PMenu;

class TItem : public TObject
{
  public:
    FontPtr UsedFont;
    int     Style, Actif, ItemID;
    PMenu   Child;
    char    *Title;

    TItem(FontPtr font, int style, char *title, int id);
    virtual ~TItem();

    virtual void Draw();
    virtual void Restore();
    virtual int  HandleEvent(int key);
    virtual void GetCoords(int *X, int *Y);
    virtual void Diffuse();
    virtual void SetChild(PMenu menu);
};

typedef TItem *PItem;

class TMenu : public TObject
{
  public:
    PItem *Items;
    int   NbItems, Child;
    char  *Title;

    TMenu(int x, int y, char *title);
    virtual ~TMenu();

    virtual void Draw();
    virtual void Restore();
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();
    virtual void Diffuse();
    virtual int  HandleEvent(int key);
    virtual void AddItem(PItem item);
};

class TMenuItm : public TObject
{
  public:
    FontPtr UsedFont;
    int     Style, Actif, ItemID;
    PMenu   Menu;
    char    *Title;

    TMenuItm(FontPtr font, int style, char *title, int id);
    virtual ~TMenuItm();

    virtual void Draw();
    virtual void Restore();
    virtual void Diffuse();
    virtual int  HandleEvent(int key);
    virtual void GetCoords(int *X, int *Y);
    virtual void SetMenu(PMenu menu);
};

typedef TMenuItm *PMenuItm;

class TMenuBar : public TObject
{
  public:
    PMenuItm *Items;
    int      NbItems;

    TMenuBar(int x, int y);
    virtual ~TMenuBar();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();
    virtual void AddItem(PMenuItm item);
};

typedef TMenuBar *PMenuBar;

// TWindow : guess what it is...

class TWindow : public TObject
{
  public:
    PClient  Clients[15];
    int      NbClients;
    char     *Title;

    TWindow(int x, int y, int xsize, int ysize, char *title);
    virtual ~TWindow();

    virtual void NewClient(PClient client);
    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();
    virtual int  GetFocus();
    virtual void GetSize(int *X, int *Y);

  private:
    void         Move();
    void         ReSize();
};

extern  PDesk   LGE;

#endif
