//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <hstring.hxx>

__hstring_elem *_hstring::first=NULL;
__hstring_elem *_hstring::notused=NULL;

#define HSTRALL(s,len,_size) \
    if (len>=_size) { _size=(len+1)<<1;s=(char *) realloc(s,_size); }
#ifdef WIN32
  #define hstrnicmp _strnicmp
#else
  #define hstrnicmp strncasecmp
#endif

_hstring::~_hstring()
{ 
  __hstring_elem *e;
  if (notused==NULL) {
    e=new __hstring_elem;
  }
  else {
    e=notused;
    notused=notused->next;
  }
  e->next=first;
  first=e;
  e->S=S;
  e->_size=_size;
}

_hstring::_hstring() 
{ 
  len=0;
  if (first!=NULL) {__hstring_elem *e=first;
    S=first->S;_size=first->_size;first=first->next;e->next=notused;notused=e;
    HSTRALL(S,len,_size);
  }
  else {
    _size=1;S=(char *)malloc(_size);
  }
  S[0]='\0';
  donttrust=false; 
}

_hstring::_hstring(const char *s)
{ 
  len=strlen(s);
  if (first!=NULL) {__hstring_elem *e=first;
    S=first->S;_size=first->_size;first=first->next;e->next=notused;notused=e;
    HSTRALL(S,len,_size);
  }
  else {
    _size=len+1;S=(char*)malloc(_size);
  }
  strcpy(S,s);
  donttrust=false; 
}

_hstring::_hstring(const _hstring & s)
{ 
  if (s.donttrust) { len=strlen(s.S); }
  else { len=s.len; }

  if (first!=NULL) {__hstring_elem *e=first;
    S=first->S;_size=first->_size;first=first->next;e->next=notused;notused=e;
    HSTRALL(S,len,_size);
  }
  else {
    _size=len+1;S=(char*)malloc(_size);
  }
  strcpy(S,s.S);
  donttrust=false;
}

_hstring::_hstring(char c)
{ 
  len=1;
  if (first!=NULL) {__hstring_elem *e=first;
    S=first->S;_size=first->_size;first=first->next;e->next=notused;notused=e;
    HSTRALL(S,len,_size);
  }
  else {
    _size=2;S=(char *)malloc(_size);
  }
  S[0]=c;S[1]='\0';
  donttrust=false; 
}

_hstring::_hstring(const char *s,int l)
{ 
  len=l;
  if (first!=NULL) {__hstring_elem *e=first;
    S=first->S;_size=first->_size;first=first->next;e->next=notused;notused=e;
    HSTRALL(S,len,_size);
  }
  else {
    _size=len+1;S=(char *)malloc(_size);
  }
  strncpy(S,s,len);
  S[len]='\0';
  len=strlen(S);
  donttrust=false;
}

void _hstring::_set(const char *s,int l)
{ 
  len=l;
  HSTRALL(S,len,_size);
  strncpy(S,s,len);
  S[len]='\0';
  len=strlen(S); 
}

_hstring & _hstring::assign(const char *s,int l)
{ 
  _set(s,l);
return *this; 
}

_hstring & _hstring::assign(const _hstring & s,int offset,int l)
{ 
  if (l==-1) {
    if (s.donttrust) { l=strlen(s.S)-offset; } else { l=s.len-offset; }
  }
  _set(s.S+offset,l);
return *this; 
}

_hstring & _hstring::operator =(const _hstring & s)
{ 
  if (s.donttrust) { len=strlen(s.S); }
  else { len=s.len; }
  HSTRALL(S,len,_size);strcpy(S,s.S);
  return *this; 
}

_hstring & _hstring::operator =(const char *s)
{ 
  len=strlen(s);
  HSTRALL(S,len,_size);
  strcpy(S,s);
  return *this; 
}

_hstring & _hstring::operator =(char c)
{ 
  len=1;
  HSTRALL(S,len,_size);
  S[0]=c;S[1]='\0';
  return *this; 
}

_hstring & _hstring::operator +=(const _hstring & s)
{  
  if (donttrust) { len=strlen(S);donttrust=false; }
  int l=len;
  if (s.donttrust) { len+=strlen(s.S); } else { len+=s.len; }
  HSTRALL(S,len,_size);
  strcpy(S+l,s.S);
  return *this; 
}

_hstring & _hstring::operator +=(const char *s)
{ 
  if (donttrust) { len=strlen(S);donttrust=false; }
  int l=len;
  len+=strlen(s);
  HSTRALL(S,len,_size);
  strcpy(S+l,s);
  return *this; 
}

_hstring & _hstring::operator +=(char c)
{ 
  if (donttrust) { len=strlen(S);donttrust=false; }
  len+=1;
  HSTRALL(S,len,_size);
  S[len-1]=c;S[len]='\0';
  return *this;
}

void _hstring::resize(int l)
{ 
  len=l;
  HSTRALL(S,len,_size);
  S[len]='\0';
}

char & _hstring::operator[](int i)
{ 
  if (i>=len) { 
    len=i+1;
    HSTRALL(S,len,_size);
    donttrust=true;
    S[len]='\0'; 
  }
  return S[i];
}

char _hstring::operator[](int i) const
{ 
  return S[i]; 
}

int _hstring::compare(const char *s,int offset,int l)
{ 
  if (l==-1) {
    if (donttrust) { len=strlen(S);donttrust=false; }
    if (l==-1) { l=len-offset; }
  }
  return strncmp(S+offset,s,l);
}

int _hstring::compare(char c,int offset,int l)
{ 
char s[2]={c,'\0'};
  return compare(s,offset,l);
}

int _hstring::compare(const _hstring &s,int offset,int l)
{ 
  if (l==-1) {
    if (donttrust) { len=strlen(S);donttrust=false; }
    l=len-offset;
  }
  return strncmp(S+offset,s.S,l);
}

int _hstring::icompare(const char *s,int offset,int l)
{ 
  if (l==-1) {
    if (donttrust) { len=strlen(S);donttrust=false; }
    l=len-offset;
  }
  return hstrnicmp(S+offset,s,l);
}

int _hstring::icompare(char c,int offset,int l)
{ 
char s[2]={c,'\0'};
  return icompare(s,offset,l);
}

int _hstring::icompare(const _hstring &s,int offset,int l)
{ 
  if (l==-1) { 
    if (donttrust) { len=strlen(S);donttrust=false; }
    l=len-offset;
  }
  return hstrnicmp(S+offset,s.S,l);
}

bool _hstring::operator < (const _hstring & s) 
{ 
return strcmp(S,s.S)<0; 
}

bool _hstring::operator < (const char *s)     
{ 
return strcmp(S,s)<0; 
}

bool _hstring::operator < (char c)      
{ 
char s[2]={c,'\0'};
return strcmp(S,s)<0;  
}

bool _hstring::operator ==(const _hstring & s) 
{ 
return strcmp(S,s.S)==0; 
}

bool _hstring::operator ==(const char *s)     
{ 
return strcmp(S,s)==0; 
}

bool _hstring::operator ==(char c)      
{ 
char s[2]={c,'\0'};
return strcmp(S,s)==0; 
}

bool _hstring::operator !=(const _hstring & s) 
{ 
return strcmp(S,s.S)!=0; 
}

bool _hstring::operator !=(const char *s)     
{ 
return strcmp(S,s)!=0; 
}

bool _hstring::operator !=(char c)      
{ 
char s[2]={c,'\0'};
return strcmp(S,s)!=0; 
}

bool _hstring::operator > (const _hstring & s) 
{ 
return strcmp(S,s.S)>0; 
}

bool _hstring::operator > (const char *s)     
{ 
return strcmp(S,s)>0; 
}

bool _hstring::operator > (char c)      
{ 
char s[2]={c,'\0'};
return strcmp(S,s)>0; 
}

_hstring _hstring::substr(int offset,int l)
{ 
  if (l==-1) {
    if (donttrust) { len=strlen(S);donttrust=false; }
    l=len-offset;
  }
  _hstring R(S+offset,l);
  return R;
}

const char *_hstring::c_str(void) const
{ 
return (const char *) S; 
}

const char *_hstring::data(void) const
{
return (const char *) S;
}

unsigned int   _hstring::length(void) 
{
 if (donttrust) { len=strlen(S);donttrust=false; }
 return len; 
}

unsigned int _hstring::size(void) 
{
 if (donttrust) { len=strlen(S);donttrust=false; }
 return len; 
}

bool _hstring::empty(void) 
{
return length()==0;
}

unsigned int _hstring::capacity(void) const
{
return _size;
}

void _hstring::swap(_hstring & s)
{
char *H=s.S;
int   ln=s.len,sz=s._size;
bool  dt=s.donttrust;
   s.S=S;s.len=len;s._size=_size;s.donttrust=donttrust;
   S=H;len=ln;_size=sz;donttrust=dt;
}

hstring & _hstring::append(const _hstring & s,int offset,int l)
{
  if (donttrust) { len=strlen(S); }
  if (l==-1) {
    if (s.donttrust) { l=strlen(s.S+offset); } else { l=s.len-offset; }
  }
  else { donttrust=true; }
  int l1=len;
  len+=l;
  HSTRALL(S,len,_size);
  strncpy(S+l1,s.S+offset,l);
  S[len]='\0';
return *this;
}

hstring & _hstring::append(const char *s,int l)
{
  if (donttrust) { len=strlen(S); }
  if (l==-1) { l=strlen(s); }
  else { donttrust=true; }
  int l1=len;
  len+=l;
  HSTRALL(S,len,_size);
  strncpy(S+l1,s,l);
  S[len]='\0';
return *this;
}

hstring & _hstring::append(int n,char c)
{
  if (donttrust) { len=strlen(S); }
  int l1=len;
  len+=n;
  HSTRALL(S,len,_size);
  memset(S+l1,c,n);
  S[len]='\0';
return *this;
}

hstring & _hstring::assign(int n,char c)
{
  HSTRALL(S,n,_size);
  memset(S,c,n);
  S[n]='\0';
  len=n;
return *this;
}

hstring & _hstring::assign (const char *s)
{
  len=strlen(s);
  HSTRALL(S,len,_size);
  strcpy(S,s);
return *this;
}

int _hstring::find(const _hstring & s,int offset)
{
char *f=strstr(S+offset,s.S);
  if (f==NULL) { 
    if (donttrust) { len=strlen(S);donttrust=false; }
    return len; 
  }
  else {
    return f-S;
  }
}

int _hstring::find(const char *s,int offset,int l)
{
int i=offset;
  if (donttrust) { len=strlen(S);donttrust=false; }
  int n=len-l;
  for(;(i+l)<n;i++) {
    if (strncmp(S+i,s,l)==0) { return i; }
  }
  return len;
}

int _hstring::find(const char *s,int offset)
{
char *f=strstr(S+offset,s);
  if (f==NULL) {
    if (donttrust) { len=strlen(S);donttrust=false; }
    return len;
  }
  else {
    return f-S;
  }
}

int _hstring::find(char c,int offset)
{
char s[2]={c,'\0'};
return find(s,offset);
}

int _hstring::rfind(const _hstring & s,int offset)
{
return rfind(s.S,offset);
}

int _hstring::rfind(const char *s,int offset)
{
  if (offset==-1) { 
    if (donttrust) { len=strlen(S);donttrust=false; }
    offset=len;
  }
  int i=offset;
  for(;i>=0;i--) {
    if (strcmp(S+i,s)==0) { return i; }
  }
  return len;
}

int _hstring::rfind(const char *s,int offset,int l)
{
  if (donttrust) { len=strlen(S);donttrust=false; }
  if (l>len) { return len; }

  int i=len-l;
  if (i>offset) { i=offset; }

  for(;i>=0;i--) {
    if (strncmp(S+i,s,l)==0) { return i; }
  }
  return len;
}

int _hstring::rfind(char c,int offset)
{
char S[2]={c,'\0' };
return rfind(S,offset);
}

_hstring operator +(const char *s,const _hstring & s1)
{ 
_hstring R(s);
  return R+=s1;
}

_hstring operator +(const _hstring & s,const char *s1)
{ 
_hstring R(s);
  return R+=s1;
}

_hstring operator +(char c,const _hstring & s1)
{
_hstring R(c);
  return R+=s1;
}

_hstring operator +(const _hstring & s1,char c)
{
_hstring R(s1);
  return R+=c;
}

_hstring operator +(const _hstring & s,const _hstring & s1)
{
_hstring R(s);
  return R+=s1;
}

#undef hstrnicmp
#undef HSTRALL

