//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <strext.hxx>
#include <hregex.hxx>
#include <stdio.h>

int main()
{
string s="Hallo dit is een testje",s1;
string r,r1;
int i;
try {
  r1="Hallo";
  printf("%d\n",r1.length());

  for(i=0;i<10;i++) {
    r1[i]='A'+i;
  }
  printf("%s\n",r1.c_str());

  {string r="Hallo allemaal";
     Take(r,r,5);
     printf("%s %d\n",r.c_str(),r.length());
  }
  {string r="Hallo allemaal";
     Take(r,r,50);
     printf("%s %d\n",r.c_str(),r.length());
  }
  {string r="Hallo allemaal";
     Drop(r,r,5);
     printf("%s %d\n",r.c_str(),r.length());
  }
  {string r="Hallo allemaal";
     Drop(r,r,50);
     printf("%s %d\n",r.c_str(),r.length());
  }


  printf("%s\n",s.c_str());

  Take(r,s,5);
  printf("Take 5:%s\n",r.c_str());

  Drop(r,s,6);
  printf("Drop 6:%s\n",r.c_str());

  {string m="^H...";
    hregex R(m); 
    R.match(s);
    cout << R.length() << "\n";
    Take(r,s,R.length());
    printf("%s\n",r.c_str());
  }
  {string m="^H...";
    hregex R(m); 
    R.match(s);
    cout << R.length() << "\n";
    Take(r,s,R.length());
    printf("%s\n",r.c_str());
  }
  TakeWhile(r,s,"H...");
  printf("TakeWhile H...:%s\n",r.c_str());

  TakeWhile(r,s,"Hall");
  printf("TakeWhile Hall:%s\n",r.c_str());
  
  DropWhile(r,s,"(.*)een");
  printf("DropWhile (.*)een:%s\n",r.c_str());

  s1="   Hoi    ";
  s=s1;
  printf("%s\n",s.c_str());

  DropWhile(r,s,"[ ]*");
  printf("DropWhile [ ]*:%s\n",r.c_str());

  
  Trim(r,s);
  printf("Trim:%s:%d\n",r.c_str(),r.length());

  s.resize(0);
  s="AAABChallo172342";
  printf("Original:%s:%d\n",s.c_str(),s.length());

  Trim(r,s,"[A-C]+","[1-4]+");
  printf("Trim:%s:%d\n",r.c_str(),r.length());

  TakeWhile(r,s,"[A-C]+");
  printf("TKW [A-C]+:%s:%d\n",r.c_str(),r.length());

  TakeWhile(r,s,"[A-C]");
  printf("TKW [A-C]:%s:%d\n",r.c_str(),r.length());

  printf("Original:%s:%d\n",s.c_str(),s.length());

  s[0]=28;s[1]=29;s[2]=30;s[3]=31;
  TakeWhile(r,s,"....");
  printf("TKW ....:%s:%d\n\n\n",r.c_str(),r.length());

  string reg="[ - ]+[A-Z]";
  reg[1]=28;
  reg[3]=31;
  TakeWhile(r,s,reg);
  printf("TKW %s:%s:%d\n\n\n",reg.c_str(),r.c_str(),r.length());
  printf("Original:%s:%d\n",s.c_str(),s.length());

  string set="01234566789",lit="?";

  s="123.232";
  TakeWhileInSet(r,s,set,lit);
  printf("TKWIS %s:%s:%s:%d\n\n\n",
           set.c_str(),lit.c_str(),r.c_str(),r.length());
  printf("Original:%s:%d\n",s.c_str(),s.length());

  s="123?5.222";
  TakeWhileInSet(r,s,set,lit);
  printf("TKWIS %s:%s:%s:%d\n\n\n",
           set.c_str(),lit.c_str(),r.c_str(),r.length());
  printf("Original:%s:%d\n",s.c_str(),s.length());

  s="ABC?52.222";
  TakeWhileNotInSet(r,s,set,lit);
  printf("TKWNIS %s:%s:%s:%d\n\n\n",
           set.c_str(),lit.c_str(),r.c_str(),r.length());
  printf("Original:%s:%d\n",s.c_str(),s.length());


  s="Hallo allemaal.100";
  RDrop(r,s,3);
  cout << r << "\n";

  RTake(r,s,3);
  cout << r << "\n";

  RDropWhileNotInSet(r,s,".");
  cout << r << "\n";




  TakeWhile(r,s,"[A-C");


}

catch(char *m) {
  int e;
    e=atoi(m+1);
    printf("%s\n",m);
    exit(e);
}

return 0;
}
