//
// this source code 
// (c) 1996 a.cella (cella@marvin.conecta.it)
//
#define HXPGM "heat exchanger"
#define HXVERS "v.0.1.2"

//
// this is for cerr
//
#include <iostream.h>

//
// and this one because
// getVersion() returns a 'String'
//
#include <String.h>

#include "heatXC.h"

int main()
{
  heatXC aHeat;
  double effcn;

  cerr<< HXPGM << "-" << HXVERS << endl;
  cerr<< "(using " << aHeat.getVersion() << ")" << endl;
  
  cout << "\nset efficiency: "; cin >> effcn;
  aHeat.setEfficiency(effcn);

  String hid,cid;

  cout << "set HOT fluid id: "; cin >> hid;
  if(!aHeat.setHotFluid(hid))
  {
    cout << "cannot find requested fluid id..." << endl;
    return 1;
  };
  
  cout << "set COLD fluid id: "; cin >> cid;
  if(!aHeat.setColdFluid(cid))
  {
    cout << "cannot find requested fluid id..." << endl;
    return 1;
  };
 
  double hmf,cmf;

  cout << "set HOT fluid massflow: "; cin >> hmf;
  aHeat.setHotFluidMassFlow(hmf);
  cout << "set COLD fluid massflow: "; cin >> cmf;
  aHeat.setColdFluidMassFlow(cmf);

  double cint,hint;

  cout << "set COLD fluid inlet T: "; cin >> cint;
  aHeat.setColdFluidInletT(cint);

  cout << "set HOT fluid inlet T: "; cin >> hint;
  aHeat.setHotFluidInletT(hint);

  double toutc,touth;

  toutc=aHeat.getColdFluidOutletT();
  touth=aHeat.getHotFluidOutletT();
  cout << endl << "COLD fluid outlet T is: " << toutc << " K." <<endl;
  cout << endl << "HOT fluid outlet T is : " << touth << " K." <<endl;

  return 0;
}
