//
// THandler.cc -- tests functionality of elementHandler and plantElement classes 
//                (as well as its derivatives)
//
// (c) 1996 a.cella (cella@marvin.conecta.it)
//
// this offers NO WARRANTY, blah, blah, blah...
// see the GNU GPL v.2
//

#include <iostream.h>

#include "elementHandler.h"

#include "plantElement.h"

#include "compress.h"
#include "turbine.h"

//
// to compensate for the lack of readability...
// PMFV is a Pointer to Member Function 
// which needs argument of type Void :)
// see stroustrup, chap.5 (Classes, Pointers to Members)
//
typedef void (plantElement::*PMFV)(void);

main()
{
  //
  // define two iterators
  // over plantElement* 's (note the syntax, though...)
  //
  elementHandler<plantElement> kontainer, kont;

  //
  // shows version info :)
  //
  cerr << kontainer.getVersion() << endl << endl;


  //
  // define some plantElement's indirectly derived classes:
  // "compressor" and "turbine" 
  // (which are actually derived from "turbomac")
  //
  compressor e1("bassa pressione",2), e2("alta pressione",3);
  turbine e3("turbinona",4);

  //
  // NOTE: this cannot be done, since plantElement has a 
  // pure virtual member, and thus is an abstract class
  //
  // plantElement *e4=new plantElement;
  // plantElement *e5=new plantElement;
  //
  
  //
  // though what follows can be done...
  // (but it is left to the user the check 
  // for "hyperspace" plantElement* 's, that is
  // pointers without an object to point to...)
  // i mean... try to uncomment the following two lines
  // of code and comment the two which follow them...
  // kabooooom! :)
  //
  // plantElement* e4;
  // plantElement* e5;
  //
  plantElement* e4 = &e1;
  plantElement* e5 = &e2;

  //
  // inserts some pointers in reverse order
  // (use elementHandler::insAtBack(plantElement*) instead...)
  //
  kontainer.insAtFront(e5);
  kontainer.insAtFront(e4);
  kontainer.insAtFront(&e3);
  kontainer.insAtFront(&e2);
  kontainer.insAtFront(&e1);
  
  //
  // assign some members to pointer to 
  // member function q and p...
  //
  // these are no longer void in v.0.8.1...
  //  PMFV p=&plantElement::showVersion;
  //  PMFV q=&plantElement::showName;
  
  //
  // use the supposed cute (?) scanExec method
  // of elementHandler, which scans the list and
  // calls the member function specified from the
  // PMFV for each element.
  //
  //  kontainer.scanExec(q);
  //  kontainer.scanExec(q);
  //
  for(int tramaj=1; tramaj<=kontainer.n(); tramaj++)
    {
      cerr << "element no." << tramaj << ": ";
      cerr << (kontainer.gimmeNo(tramaj))->getName();
      cerr << " (ID=";
      cerr << (kontainer.gimmeNo(tramaj))->getID();
      cerr << ")." << endl;
    }
  
  //
  // routine miscellanea checking of:
  // elementHandler::empty()
  // elementHandler::n()
  // elementHandler::gimmeNo(int)
  //
  cerr << endl << "Q: is the list empty? A: " << kontainer.empty() << endl;
  cerr << "number of elements present: " << kontainer.n() << endl;
  cerr << "get (hopefully) non null <T>* : " << kontainer.gimmeNo(2) << endl;
  cerr << "call to gimmeNo(2)->getName(): "; cerr << (kontainer.gimmeNo(2))->getName() << endl;
  cerr << endl;

  cerr << endl << "now with another list..." << endl;
  cerr << "Q: is the list empty? A: " << kont.empty() << endl;
  cerr << "number of elements present: " << kont.n() << endl;
  cerr << "get null <T>* : " << kont.gimmeNo(2) << endl;
  cerr << "call to gimmeNo(2)->getName(): [SHOULD GIVE ERROR (e.g. SIGSEGV) !] "; cerr <<( kont.gimmeNo(2))->getName() << endl;
  cerr << endl;
  

  return 0;
}

