#include <iostream.h>

#include <qobjcoll.h>

#include "TButtonGroup.h"


TButtonGroup::TButtonGroup(QWidget *parent, const char *name) {
  TButtonGroup("", parent, name);
}

TButtonGroup::TButtonGroup(const char *title, QWidget *parent, const char *name): QButtonGroup(title, parent, name) {
  layout = new QVBoxLayout(this, 10);

  layout->addSpacing(fontMetrics().height());
  layout->activate();

}


TButtonGroup::~TButtonGroup() {
}


void TButtonGroup::setEnabled(bool enabled) {
  QButtonGroup::setEnabled(enabled);

  QObjectListIt it(*queryList("QButton"));
  for ( ; it.current() ; ++it)
    ((QButton*)it.current())->setEnabled(enabled);
}

    
void TButtonGroup::setActive(int i) {
  QButton *b = find(i);
  
  if (b) {
    b->animateClick();
  }
}


int TButtonGroup::insert(QString name) {
  QButton *but;
  
  cout << "Adding button: " << name << endl;

  if (isExclusive())
    but = new QRadioButton(name, this, name);
  else
    but = new QCheckBox(name, this, name);

  but->adjustSize();
  layout->addWidget(but, 1);
}

int TButtonGroup::remove(QString name) {
  QObjectListIt it(*queryList("QButton"));

  for ( ; it.current() ; ++it) {
    if (it.current()->name() == name)
      break;
  }

  if (it.current()) {
    delete it.current();
    rebuildLayout();
  }
}


void TButtonGroup::rebuildLayout() {
  delete layout;

  layout = new QVBoxLayout(this, 10);
  layout->addSpacing(fontMetrics().height());

  QObjectListIt it(*queryList("QButton"));
  for ( ; it.current() ; ++it)
    layout->addWidget((QButton*)it.current(), 1);
  layout->activate();
}

QSize TButtonGroup::sizeHint() {
  QSize foo;

  QObjectListIt it(*queryList("QButton"));
  for ( ; it.current() ; ++it) {
    QButton *b = (QButton*)it.current();
    if (b->width() > foo.width())
      foo.setWidth(b->width());
    foo.setHeight(foo.height() + b->height());
  }

  foo.setWidth(foo.width());  
  foo.setHeight(foo.height() + 20 + fontMetrics().height());

  cout << "TButtonGroup->" << name() << "::sizeHint(" << foo.width() << ", " << foo.height() 
       << ")" << endl;

  return foo;
}
