#include <iostream.h>
#include <qregexp.h>
#include <qtstream.h>
#include <kmsgbox.h>

#include "TCodeEdit.h"
#include "TSignalSlot.h"
#include "TStoreType.h"
#include "TStoreType.h"

TCodeEdit::TCodeEdit() {
  fCCodeSaved = FALSE;
  fHCodeSaved = FALSE;
  fDataSaved = FALSE;
  
  fCCode = "";
  fHCode = "";
  
  fCCodeLine = 0;
  fHCodeLine = 0;
}

void TCodeEdit::initialise(QString className, QString HeadName, 
						   QString BaseClassName, QString DataName) {
  fCCode = "#include \"" + HeadName + "\"\n\n" + className + "::" + className + 
    "(QWidget *parent, const char *name) : " + BaseClassName + "(parent, name) {\n" + 
    "\tinitMetaObject();\n\tinitLayout();\n};\n\n" + 
    className + "::~" + className + "() {\n\t;\n}\n\n\n";

  QString tmp;
  tmp.sprintf("_%s_", (const char *)HeadName);
  tmp.replace(QRegExp("[^a-zA-Z0-9]"), "_");
  tmp = tmp.upper();

  fHCode = "#ifndef " + tmp + "\n#define " + tmp + "\n\n#include <qwidget.h>\n\n" +
    "class " + className + " : public " + BaseClassName + " {\n\tQ_OBJECT\npublic:\n" +
    "\t" + className + "(QWidget *parent=NULL, const char *name=NULL);\n" +
    "\t~" + className + "();\npublic slots:\nsignals:\nprotected:\nprotected slots:\nprivate:\n" +
    "\tvoid initLayout(void);\nprivate slots:\n};\n#endif /* " + tmp + " */\n";

  cCodeFile(TFileInfo(className + ".cpp"));
  hCodeFile(TFileInfo(HeadName));
  dataFile(TFileInfo(DataName));

  fClassName = className;
}
  


void TCodeEdit::renameClass(const char *oldClass, const char *newClass) {
  fCCode.replace(QRegExp(oldClass), newClass);
  fHCode.replace(QRegExp(oldClass), newClass);

  fClassName = newClass;
}

void TCodeEdit::hCodeFile(TFileInfo t) { 

  QString oldfile = fHCodeFile.fileName();
  QString newfile = t.fileName();

  fCCode.replace(QRegExp(oldfile), newfile);
  fHCode.replace(QRegExp(oldfile), newfile);

  fHCodeFile = t; 
}




void TCodeEdit::addSlotCode(TSlot *slot) {
  fCCode += "\n\nvoid " + fClassName + "::" + slot->name + "(" + 
    slot->args + ") {\n\t;\n}\n";

  QString str = "\t";
  if (slot->isVirtual)
    str = "\tvirtual";
  
  str += " void " + slot->name + " ( " + slot->args + " );\n";

  QRegExp re;
  switch (slot->privacy) {
  case spPublic:
    re = "public\\s+slots:\\s*"; break;
  case spProtected:
    re = "protected\\s+slots:\\s*"; break;
  case spPrivate:
    re = "private\\s+slots:\\s*"; break;
  };

  int pos = fHCode.find(re);
  if (pos==-1) {
    KMsgBox::message(NULL, "Error", "Can not find where to put the slot code", 
		     KMsgBox::EXCLAMATION);
    return;
  }
  
  while (fHCode[pos++] != '\n');
  fHCode.insert(pos, str);
}


void TCodeEdit::addSignalCode(TSignal *signal) {
  QString str = "\tvoid " + signal->name + " ( " + signal->args + " );\n";
  QRegExp re = "signals:";
  
  int pos = fHCode.find(re);
  if (pos==-1) {
    KMsgBox::message(NULL, "Error", "Can not find where to put the signal code", 
		     KMsgBox::EXCLAMATION);
    return;
  }
  
  while (fHCode[pos++] != '\n');
  fHCode.insert(pos, str);
}


void TCodeEdit::addNewObject(TStoreType *tree) {
  addIncludeFile(tree->headerFile());

  QString str;
  QTextStream ts(str, IO_WriteOnly);
  tree->writeHFile(ts, tree->variableName());

  QRegExp re = "private:";
  
  int pos = fHCode.find(re);
  if (pos==-1) {
    KMsgBox::message(NULL, "Error", "Can not find where to put the member declaration", 
		     KMsgBox::EXCLAMATION);
    return;
  }
  
  while (fHCode[pos++] != '\n');
  fHCode.insert(pos, str);
}

void TCodeEdit::addIncludeFile(QString file, bool local) {
  QString str = "#include\\s[<\"]" + file + "[>\"]";
  QRegExp re(str);
  int pos = fHCode.find(re);
  if (-1==pos) {
    re = "#include";
    pos = fHCode.find(re);
    if (-1==pos) {
      KMsgBox::message(NULL, "Error", "Can not find where to put the include directive", 
		       KMsgBox::EXCLAMATION);
      return;
    }
  
    //while (fHCode[pos++] != '\n');

    if (local)
      str = "#include \"" + file + "\"\n";
    else
      str = "#include <" + file + ">\n";
    fHCode.insert(pos, str);
  }
}



int TCodeEdit::findPrivateSection() {
  // Look for the private member section
  QRegExp re = "private:";
  int pos = fHCode.find(re);

  if (pos==-1) {
    KMsgBox::message(NULL, "Error", "Can not find a private section", 
		     KMsgBox::EXCLAMATION);
    return -1;
  }
  while (fHCode[pos++] != '\n');
  return pos;
}


int TCodeEdit::findPrivateMember(TStoreType *tree, QString name) {
  int pos = findPrivateSection();
  if (-1 != pos) {
    QString declaration = tree->storeTypeName() + "\\s*\\*\\s*" + name + "\\s*;";
    QRegExp re(declaration);
    return fHCode.find(re, pos);
  }
  else
    return -1;
}



void TCodeEdit::changeVariableName(TStoreType *tree, QString oldName) {
  int newPos = findPrivateMember(tree, oldName);
  QString declaration = tree->storeTypeName() + " *" + tree->variableName() + ";\n";
  if (-1==newPos) {
    // There was no declaration to begin with
    declaration = "\t" + declaration;
    fHCode.insert(findPrivateSection(), declaration);
  }
  else {
    int pos2 = newPos;
    while (fHCode[pos2++]!='\n');

    if (""==tree->variableName())
      fHCode.replace(newPos, (pos2-newPos), "");
    else
      fHCode.replace(newPos, (pos2-newPos), declaration);
  }
}



void TCodeEdit::removeVariable(TStoreType *tree) {
  int pos = findPrivateMember(tree, tree->variableName());

  if (-1 != pos) {
    int pos2 = pos;
    while (fHCode[pos2++] != '\n');
    fHCode.replace(pos, pos2-pos, "");
  }
}
