#ifndef __TCODEEDIT_H__
#define __TCODEEDIT_H__

#include <qstring.h>
#include "TFileInfo.h"

class TStoreType;
class TSignal;
class TSlot;

class TCodeEdit {
public:
  TCodeEdit();
  void initialise(QString, QString, QString, QString);

  QString &cCode() { return fCCode;};
  void cCode(const char *t) { fCCode = t; }; 

  QString &hCode() { return fHCode;};
  void hCode(const char *t) { fHCode = t; }; 

  TFileInfo cCodeFile() { return fCCodeFile;};
  void cCodeFile(TFileInfo t) { fCCodeFile = t; };

  TFileInfo hCodeFile() { return fHCodeFile;};
  void hCodeFile(TFileInfo t);

  TFileInfo dataFile() { return fDataCodeFile;};
  void dataFile(TFileInfo t) { fDataCodeFile = t; };

  int cCodeLine() { return fCCodeLine;};
  void cCodeLine(int i) { fCCodeLine = i; };

  int hCodeLine() { return fHCodeLine;};
  void hCodeLine(int i) { fHCodeLine = i; };

  bool cCodeSaved() { return fCCodeSaved; };
  void cCodeSaved(bool b) { fCCodeSaved = b; cout << "Set cCodeSaved = " << b << endl; };
  bool hCodeSaved() { return fHCodeSaved; };
  void hCodeSaved(bool b) { fHCodeSaved = b; cout << "Set hCodeSaved = " << b << endl; };
  bool dataSaved() { return fDataSaved; };
  void dataSaved(bool b) { fDataSaved = b; cout << "Set dataSaved = " << b << endl;};

  void renameClass(const char *, const char *);

  void addSlotCode(TSlot *);
  void addSignalCode(TSignal *);
  void addNewObject(TStoreType *);
  void addIncludeFile(QString, bool local=FALSE);

  void changeVariableName(TStoreType *, QString);
  void removeVariable(TStoreType *);
protected:
  int findPrivateMember(TStoreType *tree, QString name);
  int findPrivateSection();
private:
  QString fCCode, fHCode;
  TFileInfo fCCodeFile, fHCodeFile, fDataCodeFile;
  QString fClassName;
  bool fCCodeSaved, fHCodeSaved, fDataSaved;
  int fCCodeLine, fHCodeLine;
};


#endif /* __TCODEEDIT_H__ */
