#ifndef _TCONNECTION_DLG_
#define _TCONNECTION_DLG_

#include <qwindow.h>
#include <qpushbt.h>
#include <qcombo.h>

#include "TDataListBox.h"
#include "TStoreType.h"

class TDataListBoxDlg;

class TConnectionWindow: public QWindow {
  Q_OBJECT
public:
  TConnectionWindow(QWidget *parent=NULL, const char *name=NULL);
  ~TConnectionWindow();

public slots:
  void activeObject(TStoreType *w);
  void setActive(void);
  void comboActivated(const char *);
  void addNewObject(TStoreType *tree);
signals:
  void sigObjectChanged(QObject*);
  void newSignal(const char *, const char *);
  void newSlot(const char *, const char *);
protected:
  bool updateObjectList(TStoreType *tree);
  void updateObject(TStoreType *tree, QString oldName);
  void addSlotsToDlg(TDataListBoxDlg *, QString, TStoreType *, TSlotList *);
  void addSignalsToDlg(TDataListBoxDlg *, QString, TStoreType*, TSignalList*);
  void addConnectionToCurrent(TSignal *, TConnection *);

protected slots:
  void newClicked();
  void addClicked();
  void delClicked();
  void editClicked();

  void updateConnections();
  void updateConnections(int);
  void connectionHighlighted(int);
  void signalDblClick(int);
private:
  QComboBox *comboObjList;
  TDataListBox *listBoxSignals;
  TDataListBox *listBoxConnections;
  QPushButton *btnAdd, *btnDel, *btnNew, *btnEdit;

  TStoreType *fActiveObjectTree;
  TStoreType *fRootObject;
};


#endif /* _TCONNECTION_DLG_ */
