#ifndef _TFILEIOH_
#define _TFILEIOH_

#include <qstring.h>
#include <qfileinf.h>
#include "TLayoutWindow.h"
#include "TStore.h"

#define TABSTRING "\t"


class TFileIO {
public:
  TFileIO(TStore &st, TLayoutWindow &bw);

  void          layoutFilename(QFileInfo);
  QString       layoutFilename(void);
  
  QString       CFilename(void);

  int           writeLayout(void);
  int           readLayout(void);

  int           writeCode(void);

  static QString delimitString(QString);
  static QString undelimitString(QString);

  static void        writeLayoutInt(QTextStream &, QString, QString, int);
  static void        writeLayoutBool(QTextStream &, QString, QString, bool);
  static void        writeLayoutString(QTextStream &, QString, QString, QString);
  static void        writeLayoutData(QTextStream &, QString, QString, QByteArray);
  static inline QString     setTabs(int i) {
    QString tabstr = "";
    for (int j=0 ; j<i ; j++)
      tabstr += TABSTRING;
    return tabstr;
  }


  static void readLayoutUntil(QTextStream &, char);
  static int         readLayoutInt(QTextStream &);
  static bool        readLayoutBool(QTextStream &);
  static QString     readLayoutString(QTextStream &);
  static QByteArray  readLayoutData(QTextStream &);

  static QString     readDelimitedString(QTextStream &);
protected:
  QString       HeaderFilename(void);
  QString       MocFilename(void);
  QString       DataFilename(void);

  QString       actualClassName(void);
  QString       oldClassName(void);
  
  QString       defineWrapperName(const char *);

  bool dumpC();
  bool dumpH();
  bool dumpData();
  void dumpCConstructor(QTextStream &);
  void dumpSingleObject(QTextStream &, TStoreType *);
  void readData();

  void clearTempNames();
  void setTempNames();

  int           writeLayoutRecursive(TStoreType *, QTextStream &, int);
  TStoreType*  readLayoutRecursive(TStoreType *, QTextStream &);
  static uchar  readByte(QTextStream &);

  TLayoutWindow *layoutWindow() {return fLayoutWindow;};
  TStore       *store() {return fStore;};

  bool loadFile(QFileInfo fi);
private:
  TStore *fStore;
  TLayoutWindow *fLayoutWindow;

  QString fCodePrefix;
  QString fLayoutFilename;
};

#endif /* _TFILEIOH_ */
