#include <iostream.h>
#include <qwindow.h>
#include <stdlib.h>
#include "THandleGroup.h"
#include "THandle.h"

#define min(a,b) (a)<(b) ? (a) : (b)

THandleGroup::THandleGroup(QWidget *parent, const char *name): QWidget(parent, name) {
  initMetaObject();
  
  FWatched=NULL;
  fInSetHandleGroupRectLoop = FALSE;
  
  HandleNW = new THandle(THandle::NW, parent, "HandleNW");
  HandleNW->resize(8, 8);
  
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleNW, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleNW, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleN  = new THandle(THandle::N, parent, "HandleN");
  HandleN->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleN, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleN, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleNE = new THandle(THandle::NE, parent, "HandleNE");
  HandleNE->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleNE, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleNE, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleE = new THandle(THandle::E, parent, "HandleE");
  HandleE->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleE, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleE, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleSE = new THandle(THandle::SE, parent, "HandleSE");
  HandleSE->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleSE, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleSE, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleS = new THandle(THandle::S, parent, "HandleS");
  HandleS->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleS, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleS, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleSW  = new THandle(THandle::SW, parent, "HandleSW");
  HandleSW->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleSW, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleSW, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
  
  HandleW  = new THandle(THandle::W, parent, "HandleW");
  HandleW->resize(8, 8);
  connect (this, SIGNAL(sigHandleGroupRectChanged(QObject*,const QRect &)),
	   HandleW, SLOT(setPositionRect(QObject*,const QRect &)));
  connect (HandleW, SIGNAL(sigPositionRectChanged(const QRect &)),
	   this, SLOT(setHandleGroupRect(const QRect &)));
};



THandleGroup::~THandleGroup() {
  cout << "Delete Handle Group" << endl;
  delete HandleN;
  delete HandleNE;
  delete HandleE;
  delete HandleSE;
  delete HandleS;
  delete HandleSW;
  delete HandleW;
  delete HandleNW;
}

void THandleGroup::setHandleGroupRect(const QRect &rect) {
  if (fInSetHandleGroupRectLoop)
    return;
  
  fInSetHandleGroupRectLoop = TRUE;
  
  if (FWatched) {
    QRect r;
    
    r.setLeft( min(rect.left(), rect.right()) );
    r.setTop( min(rect.top(), rect.bottom()) ); 
    r.setHeight( abs(rect.height()) );
    r.setWidth( abs(rect.width()) );
    
    if (gridSize()>1) {
      r.setLeft( gridSize() * ((int) r.left()/gridSize()) );
      r.setTop( gridSize() * ((int) r.top()/gridSize()) );
      r.setHeight( gridSize() * (int) (r.height() / gridSize()) );
      r.setWidth( gridSize() * (int) (rect.width() / gridSize()) );
    } 
    FWatched->setGeometry(r);
    emit(sigHandleGroupRectChanged(FWatched, r));
  }
  else
    emit(sigHandleGroupRectChanged(FWatched, rect));
  fInSetHandleGroupRectLoop = FALSE;
}



void THandleGroup::showHandles(void) {
  HandleNW->show();
  HandleN->show();
  HandleNE->show();
  HandleE->show();
  HandleSE->show();
  HandleS->show();
  HandleSW->show();
  HandleW->show();
};


void THandleGroup::hideHandles(void) {
  HandleNW->hide();
  HandleN->hide();
  HandleNE->hide();
  HandleE->hide();
  HandleSE->hide();
  HandleS->hide();
  HandleSW->hide();
  HandleW->hide();
};


void THandleGroup::raiseHandles(void) {
  HandleNW->raise();
  HandleN->raise();
  HandleNE->raise();
  HandleE->raise();
  HandleSE->raise();
  HandleS->raise();
  HandleSW->raise();
  HandleW->raise();
}  

void THandleGroup::watched(QWidget *w) {
  FWatched = w;
  setHandleGroupRect(QRect(w->pos(), w->size()));
  showHandles();
  raiseHandles();
};


QWidget *THandleGroup::watched(void) {
  return (FWatched);
};


void THandleGroup::color(QColor col) {
  HandleNW->setBackgroundColor(col);
  HandleN->setBackgroundColor(col);
  HandleNE->setBackgroundColor(col);
  HandleE->setBackgroundColor(col);
  HandleSE->setBackgroundColor(col);
  HandleS->setBackgroundColor(col);
  HandleSW->setBackgroundColor(col);
  HandleW->setBackgroundColor(col);
};

QColor THandleGroup::color(void) {
  return (HandleNW->backgroundColor());
};



void THandleGroup::updateWatched(QObject *w, const QRect &r) {
  if (w==FWatched)
    setHandleGroupRect(r);
}


