/*
** $Source: /usr/local/share/cvs/frugal/mawc/mawc/TLayoutWindow.h,v $
** $Author: frugal $
** $Date: 1998/01/22 10:19:54 $
** $Revision: 1.3 $
** $State: Exp $
** $Log: TLayoutWindow.h,v $
** Revision 1.3  1998/01/22 10:19:54  frugal
** Cleaned up paint events
**
** Revision 1.2  1998/01/18 17:34:51  frugal
** Moved alignment functions in here from TToolWidow
**
** Revision 1.1.1.1  1998/01/13 18:48:43  frugal
**
** Revision 1.4  1998/01/12 20:12:14  frugal
** the first entry in the object tree is the first child, not the layout
** window itself.
**
** Revision 1.3  1998/01/09 22:54:54  frugal
** TLayoutWindow::open now returns a bool indicating if it succeeded
**
** Revision 1.2  1998/01/09 19:47:06  frugal
** Changed QFileInfo to TFileInfo to gain access to relFilePath(QDir &)
**
** Revision 1.1.1.1  1998/01/09 12:01:31  frugal
** MAWC initial import
**
** Revision 1.4  1997/07/09 19:02:39  frugal
** - Now renamed from TBoundWindow to TLayoutWindow
**
** Revision 1.3  1997/06/01 13:33:29  frugal
** - Now handles cut, copy, paste, delete on multiple trees.
**
**
** All source code written by Frugal (frugal@wardrobe.demon.co.uk)
*/
#ifndef _TLAYOUTWINDOW_H_
#define _TLAYOUTWINDOW_H_

#include <qwindow.h>
#include <qevent.h>
#include <qobjcoll.h>
#include <qpopmenu.h>
#include <qdialog.h>
#include <qlined.h>
#include <stdlib.h>

#include "THandleGroup.h"
#include "TPropertyWidget.h"
#include "TObjectTree.h"
#include "TCodeEdit.h"

class TMainWindow;
class TPropertyWidget;
class TStore;

/*!
  \class TLayoutWindow TLayoutWindow.h
  \brief The TLayoutWindow window provides the basis for creating 
  new dialogs in MAWC
  */
class TLayoutWindow: public QWindow {
  Q_OBJECT
public:
  TLayoutWindow(TMainWindow *, QWidget *parent=0, const char *name=0);
  ~TLayoutWindow(void);


  void show(void);
  void hide(void);

  void setMainWindow(TMainWindow *m);
  TMainWindow *mainWindow(void) { return fMainWindow; };

  void store(TStore *s) {fStore = s;};
  TStore *store(void) { return fStore; };

  void filename(QString s) { fFileName = s; };
  QString filename(void) { return fFileName; };

  void CFilename(QString s) { fCFileName = s; };
  QString CFilename(void) { return fCFileName; };

  QObjectList &selectedList() { return fSelectedList; };
  TStoreType &objectTree() { return *fObjectTree; };

  TPropertyWidget *propertyWidget();

  void setGridVisible(bool);
  bool gridVisible(void) { return fGridVisible; };
  
  void setSnapToGrid(bool);
  bool snapToGrid(void) { return fSnapToGrid; };
  
  uint gridSize() const { return fGridSize; };
  void gridSize(uint);

  TStoreType *create(TStoreType *parent, TStoreTypeCreateFn createtype);

  bool modified() { return fModified; };

  QString &text(const char *);
  void setText(const char *, const char *);
  
  int getTextRow(const char *);
  void setTextRow(const char *, int);

  void renameClass(const char *);
  void changeVariableName(TStoreType *, QString);

  TFileInfo cCodeFile() { return codeEdit.cCodeFile(); };
  TFileInfo hCodeFile() { return codeEdit.hCodeFile(); };
  TFileInfo dataFile() { return codeEdit.dataFile(); };
  void cCodeFile(TFileInfo f);
  void hCodeFile(TFileInfo f);
  void dataFile(TFileInfo f);

  bool hFileEverSaved() { return codeEdit.hCodeSaved();};
  bool cFileEverSaved() { return codeEdit.cCodeSaved();};
  bool dataEverSaved() { return codeEdit.dataSaved();};
  void hFileEverSaved(bool s) { codeEdit.hCodeSaved(s);};
  void cFileEverSaved(bool s) { codeEdit.cCodeSaved(s);};
  void dataEverSaved(bool s) { codeEdit.dataSaved(s);};

  void connectToChildDestroyed(TStoreType *);

  bool open(QFileInfo);
public slots:
  void makeModified();
  void clearModified();
  void setActive();
  void setActive(QObject *);
  void slotChildMoved(QObject*, const QRect &);

  void save();
  void saveAs();

  void generateCode();
  void generateCodeAs();
  void editCode();

  void addSignalCode(const char *, const char *);
  void addSlotCode(const char *, const char *);
  void childDestroyed();

  void setAlignTop();
  void setAlignLeft();
  void setAlignRight();
  void setAlignBottom();
  void setAlignWidths();
  void setAlignHeights();
  void setAlignVCentres();
  void setAlignHCentres();
  void setAlignVSpread();
  void setAlignHSpread();
  void setPosHCentre();
  void setPosVCentre();
signals:
  void sigChildMoved(QObject*, const QRect &);
  void sigCreatedObject(const QRect &);
  void sigCreatedObject(TStoreType *);
  void sigSetActive(TStoreType*);

  void textChanged(const char *);
protected:
  QRect calcBounds(void);

  void closeEvent(QCloseEvent *ev);

  bool eventFilter(QObject *, QEvent *);
  bool eventFilterMousePress(QObject *, QMouseEvent *);
  bool eventFilterMouseRelease(QObject *, QMouseEvent *);
  bool eventFilterMouseMove(QObject *, QMouseEvent *);

  void selectObject(const QObject*);
  void deselectObject(const QObject*);
  void deselectAll(void);

  TStoreType *createHere(TStoreType *parent, QPoint pos);

  TStoreType *copyTree(TStoreType *, TStoreType *, bool);
  TStoreType *copyObject(TStoreType *, TStoreType *, bool);
  
  void removeItem(TStoreType *);
protected slots:
  void setGrid();
  void toggleGridEnabled();
  void toggleSnapToGrid();
  void showProperties();
  void showConnections();
  void showAlignment();

  void cut();
  void copy();
  void paste();
  void remove();

private:
  QObjectList fSelectedList;
  QList<THandleGroup> fHandleGroupList;
  QList<QPoint> fMovePosList;

  TMainWindow *fMainWindow;
  TStore *fStore;
  TStoreType *fObjectTree;
  QPopupMenu *popupMenu;

  QString fFileName, fCFileName;
  bool fInGeometryLoop;
  bool fMovingWidget;
  bool fBusy;
  QPoint fOffset;
  uint fGridSize;
  bool fSnapToGrid, fGridVisible;
  bool fModified;
  TCodeEdit codeEdit;

  int fGridEnabledItem, fSnapToGridItem;
  int fmiCut, fmiCopy, fmiPaste, fmiDelete;
  int fmiRaise, fmiLower;
};


#endif /* _TLAYOUTWINDOW_H_ */
