#ifndef _TMAINWINDOW_H_
#define _TMAINWINDOW_H_

class TMainWindow;

#include <qwindow.h>
#include <qpushbt.h>
#include <qfile.h>
#include <qlayout.h>

#include <ktopwidget.h>

#include "qfrutabctrl.h"
#include "TStore.h"
#include "TLayoutWindow.h"
#include "TPushButton.h"
#include "TEditWindow.h"

class TPropertyWidget;
class TToolWindow;
class TConnectionWindow;

class TMainWindow: public KTopLevelWidget {
  Q_OBJECT
public:
  TMainWindow(TStore *, QWidget *parent=0, const char *name=0);
  ~TMainWindow();

  QString typeToCreate();

  void setStore(TStore *s);
  /*! returns a pointer to the current Store */
  TStore *store() { return fStore;};

  /*! returns a pointer to the PropertyWidget */
  TPropertyWidget *propertyWidget(void) { return fPropertyWidget;};
  /*! returns a pointer to the alignment palette */
  TToolWindow *toolWindow(void) { return fToolWindow; };
  /*! Returns a pointer to the Connection Window */
  TConnectionWindow *connectionWindow(void);
  /*! Returns a pointer to the Edit Window */
  TEditWindow *editWindow(void);

  void setActiveLayoutWindow(TLayoutWindow *);

  void addToClipBoard(TStoreType *);
  void clearClipBoard(void);

  /*! returns a reference to the list of TStoreType currently being held 
    by the clipboard */
  QList<TStoreType> &clipBoard() { return fClipBoard;};

  void setSaveDialogPath(QString s) { fSaveDialogPath = s; };
  QString saveDialogPath(void) { return fSaveDialogPath; };
  void setOpenDialogPath(QString s) { fOpenDialogPath = s; };
  QString openDialogPath(void) { return fOpenDialogPath; };
  void setSaveCodePath(QString s) { fSaveCodePath = s; };
  QString saveCodePath(void) { return fSaveCodePath; };
  void setOpenCodePath(QString s) { fOpenCodePath = s; };
  QString openCodePath(void) { return fOpenCodePath; };
public slots:
  void showProperties();
  void showAlignment();
  void showConnections();
  void showEditWindow();
  void slotShowMenubar();
  void slotShowToolbar();
  void saveSettings();

  void setAlignTop();
  void setAlignLeft();
  void setAlignRight();
  void setAlignBottom();
  void setAlignWidths();
  void setAlignHeights();
  void setAlignVCentres();
  void setAlignHCentres();
  void setAlignVSpread();
  void setAlignHSpread();
  void setPosHCentre();
  void setPosVCentre();
protected:
  TLayoutWindow *newLayoutWindow(TStoreTypeCreateFn);
  void closeEvent(QCloseEvent *);
  void updateToggles(TPushButton *);

  /*! Returns whether or not we are currently in Multi-Select Mode */
  bool multiSelect(void) { return fMultiSelect; };
  /*! Sets Multi-Select mode */
  void multiSelect(bool ms) { fMultiSelect=ms; };

  void initGui();
  void initMenu();
  void initToolbar();
  void loadSettings();
  void loadGeometry();
  void initView();
  void initStatusBar();
protected slots:
  void haveCreatedObject(const QRect &);
  void updateToggles(int,int);

  void newFile();
  void openFile();
  void saveFile();
  void saveFileAs();
  void quit();

  void editCode();

  void gridSize();
  void gridShow();
  void gridSnap();

  void showWindow(int);
  
  void setLibraryDirectory();
  void slotTabSelected(int);

  void slotAbout();
  void slotAboutQT();
  void slotHelp();
private:
  KMenuBar *menu;
  KToolBar *toolbarButtons;
  QBoxLayout *layoutWidgets;
  QPopupMenu *fWindowMenu;
  QPopupMenu *moptions;

  TPushButton *fSelectedButton, *fPointerButton;
  QObjectList panelList;
  QWidget *currentPanel;
  QfruTabCtrl *tabCtrl;
  QTabBar *classTabbar;
  KStatusBar *statusBar;

  TStore *fStore;

  TConnectionWindow *fConnectionWindow;
  TToolWindow *fToolWindow;
  TPropertyWidget *fPropertyWidget;
  TLayoutWindow *fActiveLayoutWindow;
  TEditWindow *fEditWindow;

  QList<TLayoutWindow> fLayoutWindowList;
  QList<TStoreType> fClipBoard;
  bool fMultiSelect;

  int fDefaultGridSize;
  int fShowGridId, fSnapToGridId;

  QString fSaveDialogPath;
  QString fOpenDialogPath;
  QString fSaveCodePath;
  QString fOpenCodePath;

  bool showToolbar;
  KToolBar::BarPosition toolbarPos;
  bool showMenubar;
  KMenuBar::menuPosition menubarPos;
  bool showStatusbar;
  KStatusBar::Position statusbarPos;
  
};


#endif /* _TMAINWINDOW_H_ */
