#include <qlabel.h>
#include <kcolordlg.h>
#include "TPaletteDialog.h"

TPaletteDialog::TPaletteDialog(QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal) {
  initMetaObject();
  
  fCurrentGroup = cgNormal;

  btnOK = new QPushButton(this, "OK Button");  
  btnOK->setText("OK");
  connect(btnOK, SIGNAL(clicked()), SLOT(accept()));
  btnCancel = new QPushButton(this, "Cancel Button");
  btnCancel->setText("Cancel");
  connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));

  btnCancel->adjustSize();
  btnOK->resize(btnCancel->size());

  comboGroup = new QComboBox(this);
  comboGroup->insertItem("Normal");
  comboGroup->insertItem("Active");
  comboGroup->insertItem("Disabled");
  connect(comboGroup, SIGNAL(activated(int)), SLOT(comboActivated(int)) );

  QLabel *labelGroup = new QLabel("Group :", this);
  labelGroup->setAlignment(AlignRight);
  labelGroup->adjustSize();
  labelGroup->resize(labelGroup->width(), comboGroup->height());

  QLabel *labelFore = new QLabel("Foreground :", this);
  labelFore->setAlignment(AlignRight);
  labelFore->adjustSize();
  labelFore->show();
  QLabel *labelBack = new QLabel("Background :", this);
  labelBack->setAlignment(AlignRight);
  labelBack->resize(labelFore->size());
  labelBack->show();
  QLabel *labelLight = new QLabel("Light :", this);
  labelLight->setAlignment(AlignRight);
  labelLight->resize(labelFore->size());
  labelLight->show();
  QLabel *labelMid = new QLabel("Mid :", this);
  labelMid->setAlignment(AlignRight);
  labelMid->resize(labelFore->size());
  labelMid->show();
  QLabel *labelDark = new QLabel("Dark :", this);
  labelDark->setAlignment(AlignRight);
  labelDark->resize(labelFore->size());
  labelDark->show();
  QLabel *labelText = new QLabel("Text :", this);
  labelText->setAlignment(AlignRight);
  labelText->resize(labelFore->size());
  labelText->show();
  QLabel *labelBase = new QLabel("Base :", this);
  labelBase->setAlignment(AlignRight);
  labelBase->resize(labelFore->size());
  labelBase->show();

  frameFore = new QFrame(this);
  frameFore->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameFore->resize(30, 30);
  frameFore->show();
  frameFore->installEventFilter(this);
  frameBack = new QFrame(this);
  frameBack->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameBack->show();
  frameBack->resize(30, 30);
  frameBack->installEventFilter(this);
  frameLight = new QFrame(this);
  frameLight->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameLight->show();
  frameLight->resize(30, 30);
  frameLight->installEventFilter(this);
  frameMid = new QFrame(this);
  frameMid->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameMid->show();
  frameMid->resize(30, 30);
  frameMid->installEventFilter(this);
  frameDark = new QFrame(this);
  frameDark->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameDark->show();
  frameDark->resize(30, 30);
  frameDark->installEventFilter(this);
  frameText = new QFrame(this);
  frameText->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameText->show(); 
  frameText->resize(30, 30);
  frameText->installEventFilter(this);
  frameBase = new QFrame(this);
  frameBase->setFrameStyle(QFrame::Panel | QFrame::Raised);
  frameBase->resize(30, 30);
  frameBase->show();
  frameBase->installEventFilter(this);

  resize( (frameFore->width() + labelFore->width()) * 2 + 60,
	  frameFore->height()*4 + comboGroup->height() + btnOK->height() + 70);

  comboGroup->move(width()/2 + 5, 10);
  labelGroup->move(width()/2 - (5 + labelGroup->width()), 10);

  int height = comboGroup->y() + comboGroup->height() + 10;
  labelFore->move(10, height);
  frameFore->move(labelFore->x() + labelFore->width() + 10, height);
  labelBack->move(width()/2 + 10, height);
  frameBack->move(labelBack->x() + labelBack->width() + 10, height);

  height = frameFore->y() + frameFore->height() + 10;
  labelBase->move(10, height);
  frameBase->move(labelBase->x() + labelBase->width() + 10, height);
  labelText->move(width()/2 + 10, height);
  frameText->move(labelText->x() + labelText->width() + 10, height);
 
  height = frameBase->y() + frameBase->height() + 10;
  labelLight->move(10, height);
  frameLight->move(labelLight->x() + labelLight->width() + 10, height);
  labelMid->move(width()/2 + 10, height);
  frameMid->move(labelMid->x() + labelMid->width() + 10, height);

  height = frameLight->y() + frameLight->height() + 10;
  labelDark->move(width()/2 + 10, height);
  frameDark->move(labelDark->x() + labelDark->width() + 10, height);

  height = frameDark->y() + frameDark->height() + 10;
  btnOK->move(width()/2 - (10+btnOK->width()), height);
  btnCancel->move(width()/2 + 10, height);
}



void TPaletteDialog::palette(const QPalette &pal) {
  fPalette = pal.copy();

  QColorGroup group = currentGroup();

  setFrameColor(frameFore, group.foreground());
  setFrameColor(frameBack, group.background());
  setFrameColor(frameLight, group.light());
  setFrameColor(frameMid, group.mid());
  setFrameColor(frameDark, group.dark());
  setFrameColor(frameText, group.text());
  setFrameColor(frameBase, group.base());
}


QColorGroup TPaletteDialog::currentGroup() {
  QColorGroup group;

  switch (fCurrentGroup) {
  case cgNormal:
    group = fPalette.normal();
    break;
  case cgDisabled:
    group = fPalette.disabled();
    break;
  case cgActive:
    group = fPalette.active();
    break;
  }
  return group;
}


void TPaletteDialog::setFrameColor(QFrame *frame, QColor col) {
  QColorGroup group(col, col, col.light(), col.dark(), col, col.dark(), col.light());

  frame->setPalette(QPalette(group, group, group));
}



bool TPaletteDialog::eventFilter(QObject *sender, QEvent *ev) {
  switch (ev->type()) {
  case Event_MouseButtonPress:
    QColor col = ((QFrame*)sender)->foregroundColor();
    if (KColorDialog::getColor(col)) {
      setFrameColor((QFrame *)sender, col);
      updatePalette();
    }
    return TRUE;
    break;
  }
  return FALSE;
}



void TPaletteDialog::updatePalette() {
  QColorGroup group(frameFore->foregroundColor(),
		    frameBack->foregroundColor(),
		    frameLight->foregroundColor(),
		    frameMid->foregroundColor(),
		    frameDark->foregroundColor(),
		    frameText->foregroundColor(),
		    frameBase->foregroundColor());

  switch (fCurrentGroup) {
  case cgNormal:
    fPalette.setNormal(group);
    break;
  case cgDisabled:
    fPalette.setDisabled(group);
    break;
  case cgActive:
    fPalette.setActive(group);
    break;
  }
}



void TPaletteDialog::comboActivated(int i) {
  fCurrentGroup = i;

  QColorGroup group = currentGroup();

  setFrameColor(frameFore, group.foreground());
  setFrameColor(frameBack, group.background());
  setFrameColor(frameLight, group.light());
  setFrameColor(frameMid, group.mid());
  setFrameColor(frameDark, group.dark());
  setFrameColor(frameText, group.text());
  setFrameColor(frameBase, group.base());
}




