#ifndef _TPALETTEDIALOG_H_
#define _TPALETTEDIALOG_H_

#include <qdialog.h>
#include <qframe.h>
#include <qpushbt.h>
#include <qcombo.h>

class TPaletteDialog: public QDialog {
  Q_OBJECT
public:
  TPaletteDialog(QWidget *parent=NULL, const char *name=NULL, bool modal=TRUE);

  QPalette palette() { return fPalette; };
  void palette(const QPalette &pal);
protected:
  enum { cgNormal, cgActive, cgDisabled };
  void setFrameColor(QFrame *, QColor);
  QColorGroup currentGroup();
  void updatePalette();
  bool eventFilter(QObject *, QEvent *);
protected slots:
  void comboActivated(int);
private:
  QPalette fPalette;
  QPushButton *btnOK, *btnCancel;

  int fCurrentGroup;
  QComboBox *comboGroup;
  QFrame *frameFore;
  QFrame *frameBack;
  QFrame *frameLight;
  QFrame *frameMid;
  QFrame *frameDark;
  QFrame *frameBase;
  QFrame *frameText;
};


#endif /* _TPALETTEDIALOG_H_ */
