#include <iostream.h>
#include <dlfcn.h>

#include <qlined.h>
#include <qbutton.h>
#include <qpushbt.h>
#include <qcombo.h>
#include <qfile.h>
#include <qpixmap.h>
#include <qdstream.h>
#include <qfiledlg.h>
#include <qstrlist.h>
#include <qdict.h>

#include "TStore.h"
#include "TStoreType.h"
#include "TStoreTypeQWidget.h"
#include "pics/QObject.xpm"


typedef TIntLibraryInfoList &(* intLibraryListFn)(void);


/*****************************************
 **
 **  Class: TStore
 **
 *****************************************/


TStore::TStore(QStrList &directories, QObject *parent, const char *name):QObject(parent, name) {
  initMetaObject();

  TIntLibraryInfo *d = new TIntLibraryInfo;
  d->createFn = createTypeQObject;
  d->pixmap = QPixmap((const char **)QObject_xpm);
  d->isCreatable = FALSE;
  d->isBaseClass = FALSE;
  d->storeName = "QObject";
  fTypeDict.replace("QObject", d);

  d = new TIntLibraryInfo;
  d->createFn = createTypeQWidget;
  d->pixmap = QPixmap((const char **)QObject_xpm);
  d->isCreatable = FALSE;
  d->isBaseClass = TRUE;
  d->storeName = "QWidget";
  fTypeDict.replace("QWidget", d);


  QStrListIterator pathit(directories);
  for (; pathit.current() ; ++pathit) {
	  cout << "Load libraryinfo for: " << pathit.current() << endl;

	  // Load all of the libraries in the directory
	  QDir dir;
	  dir.setPath(pathit.current());
	  dir.setNameFilter("*.par");
	  QFileInfoListIterator fileit(*dir.entryInfoList());
	  for (fileit.toFirst() ; fileit.current() ; ++fileit) {
		  getLibraryInfo(fileit.current());
	  }
  }

  QDictIterator<QStrList> dictit(libraryDict);
  for ( ; dictit.current() ; ++dictit) {
	  cout << dictit.currentKey() << endl;
	  QStrListIterator it(*dictit.current());
	  for ( ; it.current() ; ++it) {
		  cout << "\t" << it.current() << endl;
		  TClassInfo *c = classInfoDict[it.current()];
		  cout << "\t\t" << c->parentClassName << endl;

		  TClassInfo *p = classInfoDict[c->parentClassName];
		  if (p)
			  cout << "\t\t" << p->libraryName << endl;
		  else 
			  cout << "\t\tInternal" << endl;
	  }
  }
  for ( dictit.toFirst() ; dictit.current() ; ++dictit) {
	  cout << "loadLibrary: BEGIN" << dictit.currentKey() << endl;
	  loadLibrary(dictit.currentKey());
	  cout << "loadLibrary: END" << dictit.currentKey() << endl;
  }
}



void TStore::getLibraryInfo(QFileInfo *fileInfo) {
	QString libraryName = fileInfo->absFilePath();
	QFile file;
	QStrList *stringlist = new QStrList;
	char buffer[512];

	// Calculate the library name from the 'par' file
	QString libname = fileInfo->absFilePath();
	libname = libname.mid(0, libname.length()-3);
	libname += "so";

	file.setName(libraryName);
	file.open(IO_ReadOnly);

	while (file.readLine(buffer, 512) > 0) {
		QString classname, parentclassname;
		QString buf = buffer;

		buf = buf.stripWhiteSpace();

		int pos = buf.find(';');
		if (-1==pos)
			continue;

		classname = buf.mid(0, pos);
		parentclassname = buf.mid(pos+1, buf.length());
		stringlist->append(classname);

		TClassInfo *cinfo = new TClassInfo;
		cinfo->libraryName = libname;
		cinfo->parentClassName = parentclassname;

		classInfoDict.replace(classname, cinfo);
	}
	file.close();

	libraryDict.replace(libname, stringlist);
}




TStore::~TStore(void) {
  QListIterator<TLibrary> it(fLibraryList);
  for (it.toFirst() ; it.current() ; ++it) {
	  //cout << "Closing Library: " << it.current()->libName << endl;
    dlclose(it.current()->library);
  }
}




TStoreTypeCreateFn TStore::type(QString n) {
  TIntLibraryInfo *d = fTypeDict[n];
  return d ? d->createFn : NULL;
}







bool TStore::loadLibrary(QString libraryPath) {
	void *library=NULL;
	static QStrList openedClasses;

	// check to see if we have already opened it.
	QListIterator<TLibrary> it(fLibraryList);
	for ( ; it.current() ; ++it) {
		if (it.current()->libName == libraryPath) {
			library = it.current()->library;
			break;
		}
	}
	if (library) {
		cout << "loadLibary: exit(already loaded) " << libraryPath << endl;
		return TRUE;
	}

	if (halfOpenedLibraries.count()>1) {
		cout << libraryPath << ": check to see if we are opening recursivly" << endl;
		QStrListIterator it(halfOpenedLibraries);

		for (it.toFirst() ; it.current() ; ++it)
			cout << libraryPath << ": halfopened: " << it.current() << endl;

		it.toLast();
		while (it.current() == libraryPath && !it.atFirst()) {
			cout << libraryPath << ": ignoring: " << it.current() << endl;
			--it;
		}

		if (!it.atFirst()) {
			for ( ; it.current() ; --it) {
				cout << libraryPath << ": Checking against: " << it.current() << endl;
				if (it.current() == libraryPath) {
					cout << libraryPath << ": loadLibary: exit(RECURSIVE LBRARY CALL) " 
						 << endl;
					return FALSE;
				}
			}
		}
	}


	halfOpenedLibraries.append(libraryPath);


	// Open all of the required libraries for all of the classes in this
	// library
	QStrList *list = libraryDict[libraryPath];
	QStrListIterator listIt(*list);
	for ( ; listIt.current() ; ++listIt ) {
		if (!openedClasses.find(listIt.current())) {
			openedClasses.append(listIt.current());
			
			TClassInfo *cinfo = classInfoDict[listIt.current()];
			TClassInfo *pinfo = classInfoDict[cinfo->parentClassName];
			
			if (pinfo) {
				cout << libraryPath << ": LOADLIBRARY: [" << listIt.current() 
					 << "][" << cinfo->parentClassName << "]: " 
					 << pinfo->libraryName << endl;
				if (!loadLibrary(pinfo->libraryName)) {
					cout << libraryPath << ": LoadLibrary: "
						 << " exit(Unable to open sub library): " 
						 << pinfo->libraryName << endl;
					halfOpenedLibraries.removeLast();
					return FALSE;
				}
				cout << libraryPath << ": LOADLIBRARY end: [" 
					 << cinfo->parentClassName << "]: " 
					 << pinfo->libraryName << endl;
			}
		}
	}

	halfOpenedLibraries.removeLast();
	library = dlopen (libraryPath, RTLD_LAZY | RTLD_GLOBAL);
	if (library) {
		intLibraryListFn listFn = NULL;

		listFn = (intLibraryListFn)dlsym(library, "libraryInfo");
		if (!listFn)
			cerr << "dlsys failed: [libraryInfo] " << dlerror() << endl;
		else {
			TLibrary *lib = new TLibrary;
			lib->library = library;
			lib->libName = libraryPath;
			fLibraryList.append(lib);

			TIntLibraryInfoList info = listFn();
			TIntLibraryInfoListIt it(info);
			for ( ; it.current() ; ++it) {
				TIntLibraryInfo *li = it.current();
				fTypeDict.replace(li->storeName, li);
			}
			cout << "loadLibrary: Exit(SUCCESS): " << libraryPath << endl;
			return TRUE;
		}
		cout << "loadLibrary: Exit(DLSYMFAILED): " << libraryPath << endl;
		return FALSE;

	}
	cout << "loadLibrary: Exit(FAILURE): " << libraryPath << endl;
	return FALSE;
}

/*
bool TStore::loadLibrary(QFileInfo libraryName) {
  void *library=NULL;

  cout << "About to open: " << libraryName.absFilePath() << endl;

  QListIterator<TLibrary> it(fLibraryList);
  for ( ; it.current() ; ++it) {
    if (it.current()->libName == libraryName.absFilePath()) {
      library = it.current()->library;
      break;
    }
  }

  if (library) {
	  return TRUE;
  }

	  
  QString str = libraryName.baseName() + ".par";
  
  QFileInfo fileInfo( libraryName.dir(TRUE), str.data());
  if (fileInfo.exists()) {
      QString buffer(256);
      QFile file(fileInfo.absFilePath());
      
      file.open(IO_ReadOnly);
      file.readLine(buffer.data(), 256);
      file.close();
      
      buffer = buffer.stripWhiteSpace();
      QFileInfo fi2(libraryName.dir(TRUE), buffer);
      if (!loadLibrary(fi2)) {
		  return FALSE;
	  }
  }
  
  library = dlopen (libraryName.absFilePath(), RTLD_LAZY | RTLD_GLOBAL);

  if (library) {
    TStoreTypeCreateFn create = NULL;
    TStoreTypeNameFn storename = NULL;
    TStoreTypePixmapFn pix = NULL;
    TStoreTypeIsCreatableFn iscreate = NULL;
    TStoreTypeIsBaseClassFn isBase = NULL;


    create = (TStoreTypeCreateFn)dlsym(library, "createStoreType");
    if (!create)
      cerr << "dlsys failed: [createStoreType] " << dlerror() << endl;
    storename = (TStoreTypeNameFn)dlsym(library, "storename");
    if (!storename)
      cerr << "dlsys failed: [storename] " << dlerror() << endl;
    pix = (TStoreTypePixmapFn)dlsym(library, "pixmap");    
    if (!pix)
      cerr << "dlsys failed: [pixmap] " << dlerror() << endl;
    iscreate = (TStoreTypeIsCreatableFn)dlsym(library, "isCreatable");
    if (!iscreate)
      cerr << "dlsys failed: [isCreatable] " << dlerror() << endl;

    isBase = (TStoreTypeIsCreatableFn)dlsym(library, "isBaseClass");
    if (!isBase)
      cerr << "dlsys failed: [isCreatable] " << dlerror() << endl;
    
    if (create && storename && pix && iscreate && isBase) {
      TLibrary *lib = new TLibrary;
      lib->library = library;
      lib->libName = libraryName.absFilePath();
      fLibraryList.append(lib);

      TStoreTypeDict *d = new TStoreTypeDict;
      d->function = create;
      d->pixmap = pix();
      d->isCreatable = iscreate();
	  d->isBaseClass = isBase();
      fTypeDict.replace(storename(), d);
      
      return TRUE;
    }
  }
  else
    cerr << "dlopen failed: " << dlerror() << endl;
  return FALSE;
}

*/
