#ifndef _TSTOREPROPERTY_H_
#define _TSTOREPROPERTY_H_

#include <ostream.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlist.h>
#include <qpixmap.h>

class TStoreType;
class TLayoutWindow;

enum TPropertyType {ptText, ptList, ptButton};

typedef bool (TStoreType::* TStorePropertySetFn)(QString);
typedef QString (TStoreType::* TStorePropertyGetFn)();
typedef void (TStoreType::* TStorePropertyInitFn)(QObject *);
typedef void (TStoreType::* TStorePropertyActivateFn)();

#define SETFUNC(a) ((TStorePropertySetFn)a)
#define GETFUNC(a) ((TStorePropertyGetFn)a)
#define INITFUNC(a) ((TStorePropertyInitFn)a)
#define ACTIVEFUNC(a) ((TStorePropertyActivateFn)a)

/*!
  \class TStoreProperty TStoreProperty.h
  \brief The TStoreProperty class provides is used to store a single property
  in the property list for a component
  */
class TStoreProperty {
	friend ostream &operator<<(ostream &os, TStoreProperty &e);
public:
	TStoreProperty(QString n,
				   TPropertyType t,
				   TStorePropertySetFn s,
				   TStorePropertyGetFn g,
				   TStorePropertyInitFn i=NULL,
				   TStorePropertyActivateFn a=NULL,
				   bool geom=FALSE);
	QString name;
	TPropertyType propertyType;
	TStorePropertySetFn setFunc;
	TStorePropertyGetFn getFunc;
	TStorePropertyInitFn initFunc;
	TStorePropertyActivateFn activateFunc;
	bool    geometry;
};


/*!
  \class TStorePropertyList TStoreProperty.h
  \brief The TStorePropertyList provides a list of TStoreProperties
  */

typedef QListIterator<TStoreProperty> TStorePropertyListIterator;
class TStorePropertyList: public QList<TStoreProperty> {
friend ostream &operator<<(ostream &os, TStorePropertyList &l);
public:
  TStoreProperty *find(QString);
private:
  int compareItems(GCI s1, GCI s2);
};



typedef TStoreType* (* TStoreTypeCreateFn)(TStoreType *, TLayoutWindow *); 
typedef const char *(*TStoreTypeNameFn)(void); 
typedef QPixmap* (*TStoreTypePixmapFn)(void);
typedef bool (*TStoreTypeIsCreatableFn)(void);
typedef bool (*TStoreTypeIsBaseClassFn)(void);

typedef struct TIntLibraryInfo {
	TStoreTypeCreateFn createFn;
	QString storeName;
	QPixmap pixmap;
	bool isCreatable;
	bool isBaseClass;
	QString panelName;
} TIntLibraryInfo;

typedef QList<TIntLibraryInfo> TIntLibraryInfoList;
typedef QListIterator<TIntLibraryInfo> TIntLibraryInfoListIt;

#endif /* _TSTOREPROPERTY_H_ */
