/*
** $Source: /usr/local/share/cvs/frugal/mawc/mawc/TToolWindow.h,v $
** $Author: frugal $
** $Date: 1998/01/13 18:48:43 $
** $Revision: 1.1.1.1 $
** $State: Exp $
** $Log: TToolWindow.h,v $
** Revision 1.1.1.1  1998/01/13 18:48:43  frugal
**
** Revision 1.1.1.1  1998/01/09 12:01:31  frugal
** MAWC initial import
**
** Revision 1.2  1997/07/09 19:08:39  frugal
** - Renamed TBoundWindow to TLayoutWindow
**
** Revision 1.1  1997/06/01 13:53:47  frugal
** Initial revision
**
**
** All source code written by Frugal (frugal@wardrobe.demon.co.uk)
*/
#ifndef _TTOOLWINDOW_H_
#define _TTOOLWINDOW_H_

#include <qwidget.h>
#include <qpushbt.h>

class TMainWindow;
class TLayoutWindow;

/*!
\class TToolWindow TToolWindow.h
\brief The TToolWindow Class privides a flotating toolbar with
the most common alignment tools on it
*/
class TToolWindow: public QWidget {
  Q_OBJECT
public:
  TToolWindow(QWidget *parent=NULL, const char *name=NULL);
  ~TToolWindow();

  void setMainWindow(TMainWindow *m) { fMainWindow = m; };
  void setLayoutWindow(TLayoutWindow *b);
protected:
  QRect calcBounds(void);
protected slots:
  void setAlignTop();
  void setAlignLeft();
  void setAlignRight();
  void setAlignBottom();
  void setAlignWidths();
  void setAlignHeights();
  void setAlignVCentres();
  void setAlignHCentres();
  void setAlignVSpread();
  void setAlignHSpread();
  void setPosHCentre();
  void setPosVCentre();
private:
  QPushButton *btnAlignTop;
  QPushButton *btnAlignLeft;
  QPushButton *btnAlignRight;
  QPushButton *btnAlignBottom;
  QPushButton *btnAlignWidths;
  QPushButton *btnAlignHeights;
  QPushButton *btnAlignVCentres;
  QPushButton *btnAlignHCentres;
  QPushButton *btnAlignVSpread;
  QPushButton *btnAlignHSpread;
  QPushButton *btnPosHCentre;
  QPushButton *btnPosVCentre;

  TLayoutWindow *fLayoutWindow;
  TMainWindow *fMainWindow;
};

#endif /* _TTOOLWINDOW_H_ */
