#ifndef _TSTORETYPEQBUTTON_H_
#define _TSTORETYPEQBUTTON_H_

#include <TStoreTypeQWidget.h>

class TStoreTypeQButton : public TStoreTypeQWidget {
  Q_OBJECT
public:
  TStoreTypeQButton(TStoreType *, TLayoutWindow *);

  virtual QString storeTypeName();
  virtual QString headerFile();

  virtual void writeHFile(QTextStream &os, QString);
  virtual void writeCFileConstructor(QTextStream &os, QString, QString);
  virtual void writeCFileProperties(QTextStream &os, QString);
  virtual void writeCFileData(QTextStream &data, QString var);
  virtual void writeLayout(QTextStream &data, int);
  virtual void readLayoutItem(QTextStream &os, QString);

  void copyDetails(TStoreType *);

  bool isCreatable();
  bool isVisible();
  bool canItHaveChildren();
protected:
  void addProperties();

  bool QButtonSetTextFunc(QString AValue);
  QString QButtonGetTextFunc();
  
  bool QButtonSetAutoResizeFunc(QString AValue);
  QString QButtonGetAutoResizeFunc();
  void QButtonInitAutoResizeFunc(QObject *);
  
  bool QButtonSetAutoRepeatFunc(QString AValue);
  QString QButtonGetAutoRepeatFunc();
  void QButtonInitAutoRepeatFunc(QObject *);
  
  bool QButtonSetPixmapFunc(QString);
  QString QButtonGetPixmapFunc();
  void QButtonActivatePixmapFunc();
  void readPixmap(QTextStream &data, const char *, const char *);
private:
};

TStoreType *createStoreTypeQButton(TStoreType *, TLayoutWindow *);

#endif /* _TSTORETYPEQBUTTON_H_ */
