#include "TStoreTypeQCheckBox.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qchkbox.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>

#include <dlfcn.h>
#include <assert.h>



TStoreType *createStoreTypeQCheckBox(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQCheckBox(parent, lw));
}



TStoreTypeQCheckBox::TStoreTypeQCheckBox(TStoreType *p, TLayoutWindow *lw) : TStoreTypeQButton(p, lw) {
	cout << "CREATE A CHECKBOX" << endl;
	initMetaObject();

	addProperties();
	
	if (object())
		delete object();

	QCheckBox *widget;
	if (parent()) {
		QString foo = nextName(p->object(), storeTypeName());
		
		widget = new QCheckBox((QWidget*)p->object(), foo);
		widget->setText(foo);
	}
	else {
		widget = new QCheckBox(lw, "QCheckBox1");
		widget->setText("QCheckBox1");
	}
		
	object(widget);

	cout << "created CheckBox: " << object()->name() << endl;
}


// creates a list of all of the properties available to this type,
// including all of the properties from the parent
//
// There are 3 types of properties, ptText, ptList, and ptButton.
//   ptText is the most common and allows the user to type an arbitrary piece
//          of text (such as a name, or a number)
//   ptList allows the user to select from a list of options, usefull
//          for bools and enums
//   ptButton pops up a dialog with more questions, such as a file dialog which 
//          is used to select a bitmap file.
void TStoreTypeQCheckBox::addProperties() {
  TStoreProperty *sp = NULL;

  // Set up a list property
  sp = new TStoreProperty("Checked", ptList,
  			  SETFUNC(&QCheckBoxSetCheckedFunc),
  			  GETFUNC(&QCheckBoxGetCheckedFunc),
  			  INITFUNC(&QCheckBoxInitCheckedFunc), 
  			  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);
}







// The name of this type
QString TStoreTypeQCheckBox::storeTypeName() {
  return "QCheckBox";
}



// the headerfile for this type
QString TStoreTypeQCheckBox::headerFile() {
  return "qchkbox.h";
}




// The declaration line for the header file we write out
void TStoreTypeQCheckBox::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQCheckBox *" << var << ";" << endl;
}



// The constructor line for the file we write out
void TStoreTypeQCheckBox::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QCheckBox ( ";
  os << parent;
  os << ", \"" << object()->name() << "\");" << endl;
}


// Any properties that this type has, are written to the C file we generate
void TStoreTypeQCheckBox::writeCFileProperties(QTextStream &os, QString var) {
  // make sure that the parent properties are written as well
  TStoreTypeQButton::writeCFileProperties(os, var);
  
  if ( ((QCheckBox*)object())->isChecked() )
    os << "\t" << var << "->setChecked( TRUE );" << endl;
  else
    os << "\t" << var << "->setChecked( FALSE );" << endl;
}





void TStoreTypeQCheckBox::writeLayout(QTextStream &os, int tabs) {
  QCheckBox *widget = (QCheckBox*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQButton::writeLayout(os, tabs);
  TFileIO::writeLayoutBool(os, tabstr, "Checked", widget->isChecked() );
}


void TStoreTypeQCheckBox::readLayoutItem(QTextStream &is, QString propName) {
  QCheckBox *widget = (QCheckBox*) object();

  if (propName=="Checked")
    widget->setChecked(TFileIO::readLayoutBool(is));
  else
    TStoreTypeQButton::readLayoutItem(is, propName);
}




// Copy the details from one object to the other
void TStoreTypeQCheckBox::copyDetails(TStoreType *oldObj) {
  cout << "QCheckBox::copyDetails" << endl;
  QCheckBox *n = (QCheckBox *)object();
  QCheckBox *o = (QCheckBox *)oldObj->object();

  TStoreTypeQButton::copyDetails(oldObj);

  n->setChecked(o->isChecked());
  
  cout << "QCheckBox::copyDetails" << endl;
}








/********************************************************************************
**
**  Property Functions
**
**  These are used by the addProperties function to perform the underlying 
**  functionality
**
********************************************************************************/



// A ptList Property

bool TStoreTypeQCheckBox::QCheckBoxSetCheckedFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QCheckBox*)object())->setChecked(TRUE);
  ((QCheckBox*)object())->setChecked(FALSE);

  ((QCheckBox*)object())->setChecked(val);
  return TRUE;
}

QString TStoreTypeQCheckBox::QCheckBoxGetCheckedFunc() {
  if (((QCheckBox*)object())->isChecked())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQCheckBox::QCheckBoxInitCheckedFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as a Checked property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}



