#include "TStoreTypeQPushButton.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qpushbt.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qdstream.h>
#include <qfiledlg.h>
#include <qobjcoll.h>
#include <qcombo.h>

#include <dlfcn.h>
#include <assert.h>





TStoreType *createStoreTypeQPushButton(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQPushButton(parent, lw));
}


TStoreTypeQPushButton::TStoreTypeQPushButton(TStoreType *p, TLayoutWindow *lw) : TStoreTypeQButton(p, lw) {
	initMetaObject();
	addProperties();

	QPushButton *widget;
	if (parent()) {
		QString foo = nextName(parent()->object(), storeTypeName());
		widget = new QPushButton(foo, (QWidget*)parent()->object(), foo);
	}
	else
		widget = new QPushButton("QPushButton1", lw, "QPushButton1");

	if (object())
		delete object();
	object(widget);
}



void TStoreTypeQPushButton::addProperties() {
  TStoreProperty *sp = NULL;
  
  sp = new TStoreProperty("Toggle Button", ptList,
						  SETFUNC(&QPushButtonSetToggleFunc),
						  GETFUNC(&QPushButtonGetToggleFunc),
						  INITFUNC(&QPushButtonInitToggleFunc), 
						  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);
  
  sp = new TStoreProperty("Auto Default", ptList,
						  SETFUNC(&QPushButtonSetAutoDefaultFunc),
						  GETFUNC(&QPushButtonGetAutoDefaultFunc),
						  INITFUNC(&QPushButtonInitAutoDefaultFunc), 
						  0, TRUE);
  CHECK_PTR(sp);
  fProperties.inSort(sp);  
}



QString TStoreTypeQPushButton::storeTypeName() {
  return "QPushButton";
}




QString TStoreTypeQPushButton::headerFile() {
  return "qpushbt.h";
}




void TStoreTypeQPushButton::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQPushButton *" << var << ";" << endl;
}




void TStoreTypeQPushButton::writeCFileConstructor(QTextStream &os,QString var, QString parent) {
  os << "\t" << var << " = new QPushButton ( ";
  os << parent;
  os << " , \"" << name() << "\");" << endl;
}



void TStoreTypeQPushButton::writeCFileProperties(QTextStream &os, QString var) {
  TStoreTypeQButton::writeCFileProperties(os, var);
  
  QString s = ((QPushButton*)object())->isToggleButton() ? "TRUE" : "FALSE";
  os << "\t" << var << "->setToggleButton( " << s << " );" << endl;
  
  s = ((QPushButton*)object())->autoDefault() ? "TRUE" : "FALSE";
  os << "\t" << var << "->setAutoDefault( " << s << " );" << endl;
}




void TStoreTypeQPushButton::writeLayout(QTextStream &os, int tabs) {
  QPushButton *button = (QPushButton*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQButton::writeLayout(os, tabs);

  TFileIO::writeLayoutBool(os, tabstr, "Auto Default", button->autoDefault() );
  TFileIO::writeLayoutBool(os, tabstr, "Toggle Button", button->isToggleButton() );
}


void TStoreTypeQPushButton::readLayoutItem(QTextStream &is, QString propName) {
  QPushButton *button = (QPushButton*) object();

  if (propName=="Auto Default")
    button->setAutoDefault(TFileIO::readLayoutBool(is));
  else if (propName=="Toggle Button")
    button->setToggleButton(TFileIO::readLayoutBool(is));
  else
    TStoreTypeQButton::readLayoutItem(is, propName);    
}





void TStoreTypeQPushButton::copyDetails(TStoreType *oldObj) {
  cout << "QPushButton::copyDetails" << endl;
  QPushButton *n = (QPushButton *)object();
  QPushButton *o = (QPushButton *)oldObj->object();
  
  TStoreTypeQButton::copyDetails(oldObj);
  
  n->setAutoDefault(o->autoDefault());
  n->setToggleButton(o->isToggleButton());
  
  cout << "QPushButton::copyDetails" << endl;
}






bool TStoreTypeQPushButton::QPushButtonSetToggleFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QPushButton*)object())->setToggleButton(TRUE);
  ((QPushButton*)object())->setToggleButton(FALSE);
  
  ((QPushButton*)object())->setToggleButton(val);
  return TRUE;
}

QString TStoreTypeQPushButton::QPushButtonGetToggleFunc() {
  if (((QPushButton*)object())->isToggleButton())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQPushButton::QPushButtonInitToggleFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
	 << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}





bool TStoreTypeQPushButton::QPushButtonSetAutoDefaultFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QPushButton*)object())->setAutoDefault(TRUE);
  ((QPushButton*)object())->setAutoDefault(FALSE);
  
  ((QPushButton*)object())->setAutoDefault(val);
  return TRUE;
}

QString TStoreTypeQPushButton::QPushButtonGetAutoDefaultFunc() {
  if (((QPushButton*)object())->autoRepeat())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQPushButton::QPushButtonInitAutoDefaultFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
	 << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}
