#ifndef _TBOXLAYOUTTABLE_H_
#define _TBOXLAYOUTTABLE_H_

#include <qtablevw.h>
#include <qlined.h>
#include <qcombo.h>

#include "TStoreTypeQBoxLayout.h"


class TBoxLayoutTable: public QTableView {
  Q_OBJECT
public:
  TBoxLayoutTable(QBoxLayout::Direction direction, QWidget *parent=NULL, const char *name=NULL);

  void addWidget(TStoreType*, int stretch=0, int alignment=AlignCenter);
  void addLayout(TStoreType *, int stretch=0);
  void addSpacing(int);
  void addStretch(int);
  void addStrut(int);

  void clear() { fList.clear(); repaint(); };

  void deleteItem();
  void setCurrentRow(int);
  
  uint count() { return fList.count(); };
  TBoxLayoutDataItem *data(int i) { return fList.at(i);};
  TBoxLayoutDataItem *data() { return fList.at(fCurrentRow);};
  QList<TBoxLayoutDataItem> *list() {return &fList;};

protected:
  int cellWidth(int);
  void paintCell(QPainter *, int row, int col);
  bool eventFilter(QObject *, QEvent*);
  void mouseReleaseEvent(QMouseEvent *);
private:
  QBoxLayout::Direction fDirection;

  QList<TBoxLayoutDataItem> fList;
  bool fDirty;
  int fCurrentRow;

  QLineEdit *fEdit;
  QComboBox *fCombo;
};


#endif /* _TBOXLAYOUTTABLE_H_ */
