#include "TStoreTypeQLayout.h"
#include <TStoreProperty.h>
#include <TFileIO.h>

#include <qbutton.h>
#include <qcombo.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledlg.h>

#include <dlfcn.h>
#include <assert.h>


TStoreType *createStoreTypeQLayout(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQLayout(parent, lw));
}


TStoreTypeQLayout::TStoreTypeQLayout(TStoreType *p, TLayoutWindow *lw) : TStoreType(p, lw) {
	initMetaObject();
}


TStoreTypeQLayout::~TStoreTypeQLayout() {
}


void TStoreTypeQLayout::deleteLayoutTree() {
}


void TStoreTypeQLayout::rebuild(bool setRebuild) {
  fRebuilding = setRebuild;
}


void TStoreTypeQLayout::deleted() {
  //cout << "A layout item has been deleted: " << sender()->name() << endl;
  TStoreType *tree = root()->find(sender());

  tree->object(NULL);
  if (!rebuild())
    layoutMemberDeleted(tree);
  //else
  //  cout << "delete swallowed" << endl;
}


void TStoreTypeQLayout::layoutMemberDeleted(TStoreType *deleted) {
	//cout << "rebuilding due to death of child: " << deleted->className() << "::" 
	//     << deleted->name() << endl;
  rebuildLayout();
};  






// The name of this type
QString TStoreTypeQLayout::storeTypeName() {
  return "QLayout";
}



// the headerfile for this type
QString TStoreTypeQLayout::headerFile() {
  return "qlayout.h";
}


TObjectType TStoreTypeQLayout::type() {
  return otLayout;
}

bool TStoreTypeQLayout::isCreatable() {
  return FALSE;
}

bool TStoreTypeQLayout::isVisible() {
  return FALSE;
}

bool TStoreTypeQLayout::canItHaveChildren() {
  return FALSE;
}


void TStoreTypeQLayout::rebuildLayout() {
}


void TStoreTypeQLayout::recreateLayout(QLayout *) {
}

void TStoreTypeQLayout::repopulateLayout() {
}

void TStoreTypeQLayout::writePropertiesLayoutTree(QTextStream &, QString) {
}

