#include "TStoreTypeQLineEdit.h"
#include <TFileIO.h>
#include <TSignalSlot.h>

#include <qlined.h>
#include <qdir.h>
#include <qfile.h>
#include <qcombo.h>

#include <dlfcn.h>
#include <assert.h>
#include <stdlib.h>



TStoreType *createStoreTypeQLineEdit(TStoreType *parent, TLayoutWindow *lw) {
	return (new TStoreTypeQLineEdit(parent, lw));
}




TStoreTypeQLineEdit::TStoreTypeQLineEdit(TStoreType *p, TLayoutWindow *lw): TStoreTypeQWidget(p, lw) {
	addProperties();

	fSignalList.inSort(new TSignal("textChanged", "const char *"));
	fSignalList.inSort(new TSignal("returnPressed", ""));
	
	fSlotList.inSort(new TSlot("setText", "const char *"));
	fSlotList.inSort(new TSlot("selectAll", ""));
	fSlotList.inSort(new TSlot("deselect", ""));
	fSlotList.inSort(new TSlot("clearValidator", ""));
	
	QLineEdit *widget;
	if (parent()) {
		QString foo = nextName(parent()->object(), storeTypeName());
		widget = new QLineEdit((QWidget*)parent()->object(), foo);
		widget->setText(foo);
	}
	else {
		widget = new QLineEdit(lw, "QLineEdit1");
		widget->setText("QLineEdit1");
	}

	if (object())
		delete object();
	object(widget);
}


bool TStoreTypeQLineEdit::isCreatable() {
  return TRUE;
}

bool TStoreTypeQLineEdit::isVisible() {
  return TRUE;
}

bool TStoreTypeQLineEdit::canItHaveChildren() {
  return FALSE;
}



void TStoreTypeQLineEdit::addProperties() {
  TStoreProperty *se=NULL;

  se = new TStoreProperty("Text", ptText,
						  SETFUNC(&QLineEditSetTextFunc),
						  GETFUNC(&QLineEditGetTextFunc), 
						  0,
						  0, FALSE);
  CHECK_PTR(se);
  fProperties.inSort(se);
  
  se = new TStoreProperty("Max Length", ptText,
						  SETFUNC(&QLineEditSetMaxLengthFunc),
						  GETFUNC(&QLineEditGetMaxLengthFunc), 
						  0,
						  0, FALSE);
  CHECK_PTR(se);
  fProperties.inSort(se);

  se = new TStoreProperty("Frame", ptList,
						  SETFUNC(&QLineEditSetFrameFunc),
						  GETFUNC(&QLineEditGetFrameFunc),
						  INITFUNC(&QLineEditInitFrameFunc), 
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);

  se = new TStoreProperty("Echo Mode", ptList,
						  SETFUNC(&QLineEditSetEchoModeFunc),
						  GETFUNC(&QLineEditGetEchoModeFunc),
						  INITFUNC(&QLineEditInitEchoModeFunc), 
						  0, TRUE);
  CHECK_PTR(se);
  fProperties.inSort(se);
}






QString TStoreTypeQLineEdit::storeTypeName() {
  return "QLineEdit";
}



QString TStoreTypeQLineEdit::headerFile() {
  return "qlined.h";
}






void TStoreTypeQLineEdit::writeHFile(QTextStream &os, QString var) {
  if (var!="")
    os << "\tQLineEdit *" << var << ";" << endl;
}


void TStoreTypeQLineEdit::writeCFileConstructor(QTextStream &os, QString var, QString parent) {
  os << "\t" << var << " = new QLineEdit ( ";
  os << parent;
  os << ", \"" << object()->name() << "\" );" << endl;
}




void TStoreTypeQLineEdit::writeCFileProperties(QTextStream &os, QString var) {
  TStoreTypeQWidget::writeCFileProperties(os, var);
  
  QLineEdit *edit = (QLineEdit*)object();
  os << "\t" << var << "->setText( \"" 
     << edit->text() << "\" );" << endl;

  os << "\t" << var << "->setMaxLength( "
     << edit->maxLength() << " );" << endl;

  QString s = edit->frame() ? "TRUE" : "FALSE";
  os << "\t" << var << "->setFrame( " << s << " );" << endl;

  os << "\t" << var << "->setEchoMode( QLineEdit::" << QLineEditGetEchoModeFunc() << " );" << endl;

}



void TStoreTypeQLineEdit::writeLayout(QTextStream &os, int tabs) {
  QLineEdit *lineedit = (QLineEdit*)object();
  QString tabstr = TFileIO::setTabs(tabs);

  TStoreTypeQWidget::writeLayout(os, tabs);

  TFileIO::writeLayoutString(os, tabstr, "Text", lineedit->text() );
  TFileIO::writeLayoutInt(os, tabstr, "Max Length", lineedit->maxLength() );
  TFileIO::writeLayoutBool(os, tabstr, "Frame", lineedit->frame() );

  switch (lineedit->echoMode()) {
  case QLineEdit::Normal: 
    TFileIO::writeLayoutString(os, tabstr, "Echo Mode", "Normal" ); break;
  case QLineEdit::NoEcho: 
    TFileIO::writeLayoutString(os, tabstr, "Echo Mode", "NoEcho" ); break;
  case QLineEdit::Password: 
    TFileIO::writeLayoutString(os, tabstr, "Echo Mode", "Password" ); break;
  }
}


void TStoreTypeQLineEdit::readLayoutItem(QTextStream &is, QString propName) {
  QLineEdit *lineedit = (QLineEdit*) object();

  if (propName=="Text")
    lineedit->setText(TFileIO::readLayoutString(is));
  else if (propName=="Max Length")
    lineedit->setMaxLength(TFileIO::readLayoutInt(is));
  else if (propName=="Frame")
    lineedit->setFrame(TFileIO::readLayoutBool(is));
  else if (propName=="Echo Mode") {
    QString mode = TFileIO::readLayoutString(is);
    if (mode == "NoEcho")
      lineedit->setEchoMode(QLineEdit::NoEcho);
    else if (mode == "Password")
      lineedit->setEchoMode(QLineEdit::Password);
    else
      lineedit->setEchoMode(QLineEdit::Normal);
  }
  else
    TStoreTypeQWidget::readLayoutItem(is, propName);    
}





void TStoreTypeQLineEdit::copyDetails(TStoreType *oldObj) {
  cout << "QLineEdit::copyDetails" << endl;
  QLineEdit *n = (QLineEdit *)object();
  QLineEdit *o = (QLineEdit *)oldObj->object();

  TStoreTypeQWidget::copyDetails(oldObj);

  n->setText(o->text());
  n->setMaxLength(o->maxLength());
  n->setFrame(o->frame());
  n->setEchoMode(o->echoMode());
  cout << "QLineEdit::copyDetails end" << endl;
}






bool TStoreTypeQLineEdit::QLineEditSetTextFunc(QString AValue) {
  ((QLineEdit*)object())->setText(AValue);
  return TRUE;
}

QString TStoreTypeQLineEdit::QLineEditGetTextFunc() {
  return (((QLineEdit*)object())->text());
}


bool TStoreTypeQLineEdit::QLineEditSetMaxLengthFunc(QString AValue) {
  int lMaxLength;

  lMaxLength = AValue.toInt(NULL);
  ((QLineEdit *)object())->setMaxLength(lMaxLength);
  return TRUE;
}


QString TStoreTypeQLineEdit::QLineEditGetMaxLengthFunc() {
  QString s;
  return (s.setNum(((QLineEdit *)object())->maxLength()));
}





bool TStoreTypeQLineEdit::QLineEditSetFrameFunc(QString AValue) {
  char firstChar = ((const char *)AValue.lower())[0];
  bool val = ('f'!=firstChar);
  
  ((QLineEdit*)object())->setFrame(TRUE);
  ((QLineEdit*)object())->setFrame(FALSE);

  ((QLineEdit*)object())->setFrame(val);
  return TRUE;
}

QString TStoreTypeQLineEdit::QLineEditGetFrameFunc() {
  if (((QLineEdit*)object())->frame())
    return ("TRUE");
  else
    return ("FALSE");
}

void TStoreTypeQLineEdit::QLineEditInitFrameFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("FALSE");
    ((QComboBox *)w)->insertItem("TRUE");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}




bool TStoreTypeQLineEdit::QLineEditSetEchoModeFunc(QString AValue) {
  QLineEdit *edit = (QLineEdit*)object();

  edit->setEchoMode(QLineEdit::Normal);
  edit->setEchoMode(QLineEdit::NoEcho);  

  if (0==stricmp("Normal", AValue))
    edit->setEchoMode(QLineEdit::Normal);
  else if (0==stricmp("NoEcho", AValue))
    edit->setEchoMode(QLineEdit::NoEcho);
  else if (0==stricmp("Password", AValue))
    edit->setEchoMode(QLineEdit::Password);
  return TRUE;
}

QString TStoreTypeQLineEdit::QLineEditGetEchoModeFunc() {
  switch ( ((QLineEdit*)object())->echoMode() ) {
  case QLineEdit::Normal:
    return "Normal"; break;
  case QLineEdit::NoEcho:
    return "NoEcho"; break;
  case QLineEdit::Password:
    return "Password"; break;
  default:
    return "" ; break;
  }
}

void TStoreTypeQLineEdit::QLineEditInitEchoModeFunc(QObject *w) {
  // set up the list with the required strings
  if (w->inherits("QComboBox")) {
    ((QComboBox *)w)->clear();
    ((QComboBox *)w)->insertItem("Normal");
    ((QComboBox *)w)->insertItem("NoEcho");
    ((QComboBox *)w)->insertItem("Password");
  }
  else {
    cerr << "Tried to initialise " << w->name()
      << " as an AutoResize property editor" << endl;
    cerr << "however it is not a QComboBox" << endl;
  }
}











