#include <iostream.h>

#include <qapp.h>
#include <qpushbt.h>
#include <qfileinf.h>
#include <qdir.h>

#include <kapp.h>

#include "TStore.h"
#include "TMainWindow.h"
#include "TPaletteDialog.h"

int main (int argc, char **argv) {
  KApplication a(argc, argv, "mawc");
  TMainWindow *mw;
  QStrList librarylist;
  int count=0;

  // Look to see what library directories have been set up
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup( "Directories" );
  if (config)
    count = config->readListEntry("Libraries", librarylist);

  // If we have not got any set up then use a default
  if (!count) {
	  librarylist.append("/usr/local/kde/lib/mawc");
	  config->writeEntry("Libraries", librarylist);
  }

  TStore *store = new TStore( librarylist );

  mw = new TMainWindow(store, 0, "MainWindow");
  a.setMainWidget(mw);
  mw->show();

  for (int i=1 ; i<argc ; i++) {
	  cout << "Load Window: " << argv[i] << endl;
	  TLayoutWindow *lw = new TLayoutWindow(mw);
	  if (lw->open(argv[i]))
		  lw->show();
	  else {
		  cout << "Failed to load window" << endl;
		  delete lw;
	  }
  }

  a.exec();
  delete mw;
  cout << "deleted MW" << endl;


  delete store;
  cout << "Deleted Store" << endl;

  exit(0);
}



