#ifndef _QTree_H_
#define _QTree_H_

#include <qshared.h>
#include <qlist.h>
#include <qobject.h>

/*!
  \class QTree qtree.h
  \brief The QTree class is a base class for a simple resursive tree
  structure
  */
class QTree : public QObject{
  Q_OBJECT
public:
  QTree(QTree *p=NULL);
  QTree(const QTree &t);

  virtual ~QTree();


  QTree *child(uint);
  QTree *root(void);
  QTree *nextSibling();
  QTree *prevSibling();
  QTree *next(bool allowBranching=TRUE);
  QTree *prev(bool allowBranching=TRUE);
  QTree *find(QTree *, bool aFromThis=FALSE);
  QTree *firstChild(void) { return (fchildren.count()) ? fchildren.at(0) : (QTree*)NULL;};
  QTree *lastChild(void) { return (fchildren.count()) ? fchildren.at(fchildren.count()) : (QTree *)NULL;};
    

  QTree *parent() const;
  void    parent(QTree *);

  uint    numNodes(bool recursive = FALSE) const;

  int     positionInParent();
  void    positionInParent(int);

  QTree *rightmostChild();
  QTree *nextAfter(QTree *);

  void    addChild(QTree *);
  void    removeChild(QTree *);

  uint    depth()               { return fDepth;};
signals:
  void sigSetDepth(int);
  void sigAddChild(QTree *);
  void sigRemoveChild(QTree *);
  void sigParentChange(QTree *);
protected:

  void    updateDepths();
private:
  QList<QTree>  fchildren;
  QTree        *fparent;
  int           fDepth;
};

#endif /* _QTree_H_ */
