// utility.cpp

#include <strstream>
#include <cstdlib>
#include <cstdio>

#include "utility.h"

namespace Seahunt
{

// convert int to ascii
std::string 
Utility::itos( int i )
{
   std::strstream stream;
   std::string str;
   stream << i;
   stream >> str;
   return str;
}

// convert float to ascii
std::string
Utility::dtos( double d )
{
   std::strstream stream;
   std::string str;
   stream << d;
   stream >> str;
   return str;
}

void 
Utility::UserEntry ( std::string label, int & entry, int min, int max )
{
  char buff[MAXBUFF] = {0};
  bool valid = true;
  entry = -1;
  std::string range = " <" + itos(min) + " to " + itos(max) + ">";
  do
  {
    valid = false;
    std::cout << "Enter " << label  << range << ": ";
    std::cin.getline(buff, 21);
    for ( int i=0; i<strlen(buff); ++i )
    {
      if ( isdigit(buff[i]) )
      {
        valid = true;
      }
      else
      {
        valid = false;
        break;
      }
    }    
    if ( valid == true )
    {
      entry = atoi(buff); 
      if ( entry < min || entry > max )
      {
        std::cout << "\nInvalid Entry: " << entry << range << std::endl;
      }
    }
    else
    {
      std::cout << "\nInvalid Entry: " << buff << range << std::endl;
    }
  }
  while ( entry < min || entry > max );
}

void 
Utility::UserEntry ( std::string label, std::string & entry, int length )
{
  std::cout << "Enter " << label  << ": ";
  char buff[MAXBUFF] = {0};
  std::cin.getline(buff, length);  // bug in VCPP 5.0 does not work correctly
  entry = buff;
}

void
Utility::WaitKey( void )
{
  char buff[1] = {0};
  std::cout << "\nPress Any Key to Continue ";
  gets(buff);
}

void 
Utility::ClearScreen( void )
{
  std::cout << "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" << std::endl;
}

}

