// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of tdof.
// 
// The exception is that, if you link the tdof ixj library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the tdof ixj library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released by OST under the 
// name tdof.  If you copy code from other releases into a copy of
// tdof, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for tdof, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "ixj.h"
#include <stdio.h>

unsigned long IXJPort::PlayMemory(unsigned char *buf, size_t len, unsigned long termcode)
{
	int fs;

	setTerminate(termcode);
	while(len)
	{
		fs = getFrameSize();
		if(fs > len)
			fs = len;
		
		fs = PlayFrame(buf, fs);
		if(fs < 1)
			return getTerminate();

		len -= fs;
		buf += fs;
	}
	PlayStop();
	return 0l;
}

unsigned long IXJPort::RecMemory(unsigned char *buf, size_t len, unsigned long termcode)
{
	int fs;

	setTerminate(termcode);
	while(len)
	{
		fs = getFrameSize();
		if(fs > len)
			fs = len;
	
		fs = RecordFrame(buf, fs);
		if(fs < 1)
			return getTerminate();
		
		len -= fs;
		buf += fs;
	}
	RecordStop();
	return 0l;
}

unsigned long IXJPort::PlayFile(int fd, size_t max, unsigned long termcode)
{
	char *buf = new char[getFrameSize()];
	int fs;
	
	setTerminate(termcode);
	while(max)
	{
		fs = getFrameSize();
		if(fs > max)
			fs = max;

		max -= fs;

		fs = read(fd, buf, fs);
		if(!fs)
			return 0l;

		if(fs < 0)
			return 0xffffffff;

		fs = PlayFrame(buf, fs);				
		if(fs < 1)
			return getTerminate();
	}
	PlayStop();
	return 0l;
}
	
unsigned long IXJPort::RecFile(int fd, size_t max, unsigned long termcode)
{
	char *buf = new char[getFrameSize()];
	int fs;
	
	setTerminate(termcode);
	while(max)
	{
		fs = getFrameSize();
		if(fs > max)
			fs = max;

		fs = RecordFrame(buf, fs);
		if(fs < 1)
			return getTerminate();

		if(fs > max)
			fs = max;
		fs = write(fd, buf, fs);
		if(!fs)
			return 0l;

		if(fs < 0)
			return 0xffffffff;

		max -= fs;
	}
	RecordStop();
	return 0l;
}
