//===============================================================
// vkeys.h - Defintions for V keys - Windows
//
// Copyright (C) 1995  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VKEYS_H
#define VKEYS_H

    // Masks for various shift modes

#define VKM_Shift 1
#define VKM_Ctrl 4
#define VKM_Alt 8

#define VK_IsModifier(x) ((x>=VKM_Shift) && (x<=VKM_Alt))
#define vk_None		0x0	/* no key */

#define vk_BackSpace		0x08
#define vk_Tab			0x09
#define vk_Linefeed		0x0A
#define vk_Return		0x0D
#define vk_Pause		0x13
#define vk_Escape		0x1B
#define vk_Delete		0x7F

#define vk_BackTab		0xFF09

#define vk_Home			0xFF50
#define vk_Left			0xFF51
#define vk_Up			0xFF52
#define vk_Right		0xFF53
#define vk_Down			0xFF54
#define vk_Page_Up		0xFF55
#define vk_Page_Down		0xFF56
#define vk_End			0xFF57
#define vk_Insert		0xFF58

#define vk_F1			0xFFC1
#define vk_F2			0xFFC2
#define vk_F3			0xFFC3
#define vk_F4			0xFFC4
#define vk_F5			0xFFC5
#define vk_F6			0xFFC6
#define vk_F7			0xFFC7
#define vk_F8			0xFFC8
#define vk_F9			0xFFC9
#define vk_F10			0xFFCA
#define vk_F11			0xFFCB
#define vk_F12			0xFFCC
#define vk_F13			0xFFCD
#define vk_F14			0xFFCE
#define vk_F15			0xFFCF
#define vk_F16			0xFFD0

#define vk_space               0x020
#define vk_asciitilde          0x07e
#endif
