//===============================================================
// vapp.h - the vapp base object - X11R5 version
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VAPP_H
#define VAPP_H

#include <v/vbaseitm.h>	// our parent class
#include <v/vfont.h>	// our parent class
#include <v/vawinfo.h>
#include <v/vmenu.h>

extern "C"		// wrap in "C"
{
#include <X11/Core.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
}

    extern int AppMain(int, char**);

    class vWindow;

    typedef struct WindList
      {
	vWindow* window;
	vAppWinInfo* info;
	WindList* nextWinList;
      } WindList;

    class vApp : public vBaseItem
      {
	// give friend access to some special things
	friend class vWindow; // Provide access for vWindow class
	friend int main(int, char**);	// give main access

      public:		//---------------------------------------- public

	vApp(char* appName);	// constructor
	virtual ~vApp()	// destructor
	  {
	    SysDebug(Destructor,"vApp::~vApp destructor\n")
	  }

	// Methods to override

	virtual void AppCommand(vWindow* win, ItemVal id, ItemVal retval, CmdType ctype);
	virtual void CloseAppWin(vWindow* win);
	virtual void CloseHelpWin(vWindow* win);
	int IsHelpWin(vWindow *Win);
	virtual void Exit(void);
	virtual void KeyIn(vWindow* win, vKey key, unsigned int shift);
	virtual vWindow* NewAppWin(vWindow* win, char* name, int h, int w, 
		vAppWinInfo* winInfo = 0);
	virtual  vWindow* NewHelpWin(vWindow* win, char* name, int h, int w);

	// Utlity methods

	void CheckEvents();
	void GetVVersion(int& major, int& minor)
	   { major = V_VersMajor; minor = V_VersMinor; }
	int DefaultHeight() { return _DefaultHeight; }
	int DefaultWidth() {return _DefaultWidth; }
	int ScreenHeight() { return _DisplayHeight; }
	int ScreenWidth() {return _DisplayWidth; }
	int IsRunning() {return _running;}  // see if app is running
	vFont GetDefaultFont();
	void SendWindowCommandAll(ItemVal id, int val, CmdType ctype);
	void SetValueAll(ItemVal id, int val, ItemSetType setType);
	void SetAppTitle(char* title);
	void SetStringAll(ItemVal id, char* str);
	int ShowList();
	vAppWinInfo *getAppWinInfo(vWindow* Win);

	// Required internally

	vMenuPane* GetMenuThis(Widget w);	// needed for submenus

	// X stuff
	Display* display()	// To get the X display
	  { return _display; }

	XtAppContext appContext()	// To get the context
	  { return _appContext; }

	int Xdepth() {return _depth;}
	Pixel Xfg() {return _foregroundPix;}
	Pixel Xbg() {return _backgroundPix;}
	Colormap Xcolormap() {return _colormap;}

 	Pixel PixMedGray() { return _medGray;}
	Pixel PixDarkGray() { return _darkGray;}
	Pixel PixLightGray() { return _lightGray;}

	XFontStruct* _XDefaultFont;	// set by default or -fn switch

      protected:	//--------------------------------------- protected

	WindList* _WindowList;		// List of "top level" windows

	int _running;			// if we are running

	// The following two are called from main.
	void initialize(int& argc, char** argv);
	void doEventLoop();

      private:		//--------------------------------------- private

	int _DefaultHeight;
	int _DefaultWidth;

	Pixel GetGrayPixel(int Shade);

	void registerWindow(vWindow* Win, vAppWinInfo* awinfo);
	void unregisterWindow(vWindow* Win);

	// X stuff

	Display* _display;		// Needed by X sometimes
	XtAppContext _appContext;	// Main app context
	Colormap _colormap;
	Pixel _foregroundPix;		// foreground pixel value
	Pixel _backgroundPix;   	// background pixel value
 	Pixel _medGray;
	Pixel _darkGray;
	Pixel _lightGray;
	int _depth;			// depth
	int _DisplayHeight;		// height of display
	int _DisplayWidth;		// width of display

      };

    extern vApp *theApp;		// Pointer to single global instance
#endif
