//===============================================================
// vcpdc.h: CanvasPaneDC class .h file - X11R5
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VCPDC_H
#define VCPDC_H

#include <v/vdc.h>

extern "C"
{
#include <X11/Xlib.h>
}

    class vWindow;		// we are part of a window
    class vCanvasPane;

    class vCanvasPaneDC : public vDC
      {

      public:		//---------------------------------------- public

	vCanvasPaneDC(vCanvasPane* parentPane);

 	virtual ~vCanvasPaneDC();

	// Drawing

	virtual void Clear(void);
	virtual void ClearRect(int left, int top, int height, int width);
#ifdef DRAWARC
	virtual void DrawArc(int xx1, int yy1, int xx2, int yy2, int xxc, int yyc);
#endif
  	virtual void DrawAttrText(int x, int y, char* text, const ChrAttr attr);
  	virtual void DrawText(int x, int y, char* text);
	virtual void DrawEllipse(int x, int y, int width, int height);
	virtual void DrawIcon(int x, int y, vIcon& icon);
  	virtual void DrawLine(int x, int y, int xend , int yend);
	virtual void DrawPoint(int x, int y);
	virtual void DrawPolygon(int n, vPoint points[], int fillStyle);
	virtual void DrawRectangle(int x, int y, int width, int height);
	virtual void DrawRoundedRectangle(int x, int y,
		int width, int height, int radius);
  	virtual void DrawRubberLine(int x, int y, int xend, int yend);
	virtual void DrawRubberEllipse(int x, int y, int width, int height);
	virtual void DrawRubberPoint(int x, int y);
	virtual void DrawRubberRectangle(int x, int y, int width, int height);

	virtual void SetFont(vFont& vf);	// Set Text font to vf

	// Appearance

	virtual void SetBackground(vColor& color);

	virtual void SetPen(vPen& pen);

	virtual void SetBrush(vBrush& brush);

	virtual int TextHeight(int& asc, int& des);
	virtual int TextWidth(char* str);

      protected:	//--------------------------------------- protected

	unsigned long _canvasFG;	// the foreground color
	unsigned long _canvasBG;	// the background color

      private:		//--------------------------------------- private

 	vCanvasPane* _parentPane;

	Display* _XDisplay;
//	Window _XWindow;

	static vFont _GCFont;		// the font actually in the GC

	Widget _drawWidget;

	void SetPenStyle(GC gc);
  	void SetGCtoPen();
  	void SetGCtoBrush();

	// Default GC for the widget
	GC _GC;				// will be filled in
	GC _XorGC;			// will be filled in

	GC makeGC(Widget w);		// make a GC to use
	GC makeXorGC(Widget w);		// make a GC to use

      };
#endif
