//===============================================================
// vbtncmd.cpp - button Cmd - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vbtncmd.h>	// our definitions
#include <v/vcmdprnt.h>	// a command parent
#include <v/vutil.h>
#include <v/vicon.h>
#include <v/vapp.h>

//====================>>> vButtonCmd::vButtonCmd <<<=======================
  vButtonCmd::vButtonCmd(vCmdParent* dp, CommandObject* dc) :
    vCmd(dp, dc)
  {
    initialize();
  }

//====================>>> vButtonCmd::~vButtonCmd <<<=======================
  vButtonCmd::~vButtonCmd()
  {

    SysDebug(Destructor,"vButtonCmd::~vButtonCmd() destructor\n")

  }

//=====================>>> vButtonCmd::initialize <<<=======================
  void vButtonCmd::initialize()
  {
    // build a button command for use in a parent window

    SysDebug(Constructor,"vButtonCmd::vButtonCmd() constructor\n")

    long style;

    if (_parentWin->_dialogType != aCmdBar)
	style = WS_TABSTOP | WS_GROUP;	// default for a button
    else
	style = WS_GROUP;

    CopyToLocal();			// Make local copies of CmdObject

    if (!(dlgCmd->attrs & CA_Hidden))	// Check for Hidden
	style |= WS_VISIBLE;

    if (dlgCmd->cmdType == C_IconButton && _itemList != 0) // icon
      {
	initIconButton(style);		// Special init if icon
	return;
     }

    if (dlgCmd->cmdType == C_ColorButton) // need owner draw if color
	style |= BS_OWNERDRAW;
    else if ((dlgCmd->attrs & CA_DefaultButton))   // default button?
	style |= BS_DEFPUSHBUTTON;	// Only regular buttons can be default
    else
	style |= BS_PUSHBUTTON;		// Plain old button

    _w = vLblLen(_title)*4+10;		// set my width
    _h = 14;				// default height

    if (dlgCmd->cmdType == C_Button && dlgCmd->size > 0) // size - width
      {
	int w = vLblLen(_title)*4+10;
	if (w < dlgCmd->size)
	  {
            _w = dlgCmd->size;
	  }
      }
    else if (dlgCmd->size > 0)	// size - square (icons, color buttons)
      {
	_w = _h = dlgCmd->size;
      }

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame, dlgCmd->cRightOf,
	dlgCmd->cBelow);
    _CtrlOffset = _parentWin->AddDlgControl(_x, _y, _w, _h, _cmdId,
	style, "BUTTON", _title, sizeof(vButtonCmd*), (LPBYTE)this);

  }

//=====================>>> vButtonCmd::initIconButton <<<====================
  void vButtonCmd::initIconButton(long style)
  {
    _ip = (vIcon *) _itemList;	// to access bitmap

    style |= BS_OWNERDRAW;

    _h = (_ip->height / 2) + 4;
    _w = (_ip->width / 2) + 6;
    _ip->MapIcon();			// create the icon handle now

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame,
	     dlgCmd->cRightOf, dlgCmd->cBelow);

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y , _w, _h, _cmdId,
	   style, "BUTTON", "", sizeof(vButtonCmd*), (LPBYTE)this);

  }


//================>>> vButtonCmd::SetCmdVal <<<============================
  void vButtonCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {

    SysDebug1(Misc,"vButtonCmd::SetCmdVal(val:%d)\n",val)
    HWND myHwnd = GetMyHwnd(_cmdId);
    if (st == Sensitive)
      {
	_Sensitive = val;		// set
	::EnableWindow(myHwnd, val);
      }
    else if (st == Hidden)		// hide or unhide
      {
	if (val)
	  {
	    ::ShowWindow(myHwnd,SW_HIDE);
	  }
	else
	  {
	    ::ShowWindow(myHwnd,SW_SHOW);
	  }
      }
  
  }

//================>>> vButtonCmd::SetCmdStr <<<============================
  void vButtonCmd::SetCmdStr(char* str)
  {
    // Set the string value of button

    SysDebug1(Misc,"vButtonCmd::SetCmdStr(str:%s)\n",str)
    ::SetDlgItemText(_parentWin->getParent(),_cmdId, str);
    _title = str;

  }

//================>>> vButtonCmd::MEASUREITEM <<<============================
  int vButtonCmd::MEASUREITEM(int id, MEASUREITEMSTRUCT* mis)
  {
    mis->CtlType = ODT_BUTTON;
    mis->CtlID = id;
    mis->itemWidth = _w;
    mis->itemHeight = _h;
    
    return 1;
  }

//================>>> vButtonCmd::DRAWITEM <<<============================
  int vButtonCmd::DRAWITEM(int id, DRAWITEMSTRUCT* dis)
  {
    switch (dis->itemAction)
      {
	case ODA_DRAWENTIRE:	// redraw entire control
	  {
	DRAW_NORMAL:
	    if (dlgCmd->cmdType == C_IconButton)  //Draw the icon
	      {
		POINT ptSize, ptOrg;

		// Draw the button rectangle in LTGRAY with a BLACK border

		HPEN oldpen = ::SelectObject(dis->hDC, ::GetStockObject(BLACK_PEN));
		HBRUSH oldbrush = ::SelectObject(dis->hDC, theApp->_BarBrush);
		(void)::Rectangle(dis->hDC,dis->rcItem.left, dis->rcItem.top,
			dis->rcItem.right, dis->rcItem.bottom);

		// Draw the shadows - WHITE left, top, GRAY right, bottom

		::SelectObject(dis->hDC, theApp->_LightPen);
		::MoveTo(dis->hDC, dis->rcItem.left, dis->rcItem.bottom);
		::LineTo(dis->hDC, dis->rcItem.left, dis->rcItem.top);
		::LineTo(dis->hDC, dis->rcItem.right-1, dis->rcItem.top);
		::MoveTo(dis->hDC, dis->rcItem.left+1, dis->rcItem.bottom+1);
		::LineTo(dis->hDC, dis->rcItem.left+1, dis->rcItem.top+1);
		::LineTo(dis->hDC, dis->rcItem.right-2, dis->rcItem.top+1);


		::SelectObject(dis->hDC,theApp->_ShadowPen);
		::MoveTo(dis->hDC, dis->rcItem.right-1, dis->rcItem.top+1);
		::LineTo(dis->hDC, dis->rcItem.right-1, dis->rcItem.bottom-1);
		::LineTo(dis->hDC, dis->rcItem.left, dis->rcItem.bottom-1);
		::MoveTo(dis->hDC, dis->rcItem.right-2, dis->rcItem.top+1);
		::LineTo(dis->hDC, dis->rcItem.right-2, dis->rcItem.bottom-2);
		::LineTo(dis->hDC, dis->rcItem.left+1, dis->rcItem.bottom-2);


		// Get color to draw icon - GRAY or BLACK
		HBRUSH dbrush = 0;
		if (dis->itemState & ODS_DISABLED)
		  {
                    // This stuff needed to be sure it shows
		    if (::GetSysColor(COLOR_BTNSHADOW) == ::GetSysColor(COLOR_BTNFACE))
		      {
			::SelectObject(dis->hDC, ::GetStockObject(GRAY_BRUSH));
		      }
		    else
		      {
			dbrush = ::CreateSolidBrush(::GetSysColor(COLOR_BTNSHADOW));
			::SelectObject(dis->hDC, dbrush);
		      }
		  }
		else
		  {
		    ::SelectObject(dis->hDC, ::GetStockObject(BLACK_BRUSH));
		  }

		// Now setup coordinate to draw icon

		HDC hdcMem = ::CreateCompatibleDC(dis->hDC);
		::SetMapMode(hdcMem, GetMapMode(dis->hDC));
		::SelectObject(hdcMem,_ip->_hbm);
		ptSize.x = _ip->width;
		ptSize.y = _ip->height;
		DPtoLP(dis->hDC, &ptSize, 1);
		ptOrg.x = 0;
		ptOrg.y = 0;
		DPtoLP(hdcMem, &ptOrg, 1);
		::SetBkColor(dis->hDC, RGB(255,255,255)); // white bg for icon

		// Now BitBlt the icon BMP into the drawing canvas, leaving
		// background untouched, and the pen color to draw 1 bits
		// (that's what the E20746L does)
		int l = (dis->rcItem.right - _ip->width) / 2;
		int t = (dis->rcItem.bottom - _ip->height) / 2;
		::BitBlt(dis->hDC, l, t, ptSize.x,
		   ptSize.y, hdcMem, ptOrg.x, ptOrg.y, 0xE20746L);

		::DeleteDC(hdcMem);
		::SelectObject(dis->hDC, oldpen);	// restore hdc
		::SelectObject(dis->hDC, oldbrush);
		if (dbrush) ::DeleteObject(dbrush);
	      }

	    return 1;
	  }

	case ODA_SELECT:	// indicated selected
	  {
	    if (dlgCmd->cmdType == C_IconButton)
	    {
	      if (dis->itemState & ODS_SELECTED)  //Draw the icon
	      {
		POINT ptSize, ptOrg;

		// Draw the button rectangle in LTGRAY with a BLACK border
		HBRUSH fbrush = ::CreateSolidBrush(::GetSysColor(COLOR_BTNFACE));
		HPEN oldpen = ::SelectObject(dis->hDC, GetStockObject(BLACK_PEN));
		HBRUSH oldbrush = ::SelectObject(dis->hDC, fbrush);
		(void)::Rectangle(dis->hDC,dis->rcItem.left, dis->rcItem.top,
			dis->rcItem.right, dis->rcItem.bottom);
		::DeleteObject(fbrush);

		// Draw the shadows - GRAY left, top, No right, bottom
		::SelectObject(dis->hDC, theApp->_ShadowPen);
                ::MoveTo(dis->hDC, dis->rcItem.left, dis->rcItem.bottom);
		::LineTo(dis->hDC, dis->rcItem.left, dis->rcItem.top);
		::LineTo(dis->hDC, dis->rcItem.right, dis->rcItem.top);
		::MoveTo(dis->hDC, dis->rcItem.left+1, dis->rcItem.bottom-1);
		::LineTo(dis->hDC, dis->rcItem.left+1, dis->rcItem.top+1);
		::LineTo(dis->hDC, dis->rcItem.right-1, dis->rcItem.top+1);

		// Now setup coordinate to draw icon

		HDC hdcMem = ::CreateCompatibleDC(dis->hDC);
		::SetMapMode(hdcMem, GetMapMode(dis->hDC));
		::SelectObject(hdcMem,_ip->_hbm);
		ptSize.x = _ip->width;
		ptSize.y = _ip->height;
		DPtoLP(dis->hDC, &ptSize, 1);
		ptOrg.x = 0;
		ptOrg.y = 0;
		DPtoLP(hdcMem, &ptOrg, 1);
		::SetBkColor(dis->hDC, RGB(255,255,255)); // white bg for icon
                ::SelectObject(dis->hDC, GetStockObject(BLACK_BRUSH));

		// Now BitBlt the icon BMP into the drawing canvas, leaving
		// background untouched, and the pen color to draw 1 bits
		// (that's what the E20746L does) (shifted 1 from normal icon)

		int l = (dis->rcItem.right - _ip->width) / 2;
		int t = (dis->rcItem.bottom - _ip->height) / 2;
		::BitBlt(dis->hDC, l+1, t+1, ptSize.x,
		   ptSize.y, hdcMem, ptOrg.x, ptOrg.y, 0xE20746L);

		::DeleteDC(hdcMem);
		::SelectObject(dis->hDC, oldpen);	// restore hdc
		::SelectObject(dis->hDC, oldbrush);
	      }

	    else
		goto DRAW_NORMAL;
	    }
	    return 1;		// no op for icon label
	  }

	case ODA_FOCUS:		// gets focus
	  {
	    return 1;		// no op for icon label
	  }
	default:
	    break;
      }
    return 0;
  }
