//===============================================================
// vclabelc.xxx	- Color label Cmd - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vclabelc.h>	// our definitions

//=================>>> vColorLabelCmd::vColorLabelCmd <<<=======================
  vColorLabelCmd::vColorLabelCmd(vCmdParent* dp, CommandObject* dc) :
	vLabelCmd(dp, dc)
  {
    initColor();
  }

//====================>>> vColorLabelCmd::~vColorLabelCmd <<<===================
  vColorLabelCmd::~vColorLabelCmd()
  {

    SysDebug(Destructor,"vColorLabelCmd::~vColorLabelCmd() destructor\n")
  }

//=====================>>> vColorLabelCmd::initColor <<<=======================
  void vColorLabelCmd::initColor(void)
  {
    // wCmd is the widget of this button

    SysDebug(Constructor,"vColorLabelCmd::vColorLabelCmd() constructor\n")

    if (_itemList != 0)				// an RGB provided
      {
	vColor* color = (vColor*)_itemList;	// point to the rgb
	_color.Set(color->r(), color->g(), color->b());
      }
    
  }

//================>>> vColorLabelCmd::SetCmdVal <<<============================
  void vColorLabelCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {

    SysDebug1(Misc,"vColorLabelCmd::SetCmdVal(val:%d)\n",val)

    switch (st)
      {
	case Red:
	    _color.SetR(val);
	    break;

	case Green:
	    _color.SetG(val);
	    break;

	case Blue:
	    _color.SetB(val);
	    break;

	default:
	    vLabelCmd::SetCmdVal(val, st);
	    break;
      }
  }
