//===============================================================
// vdrawing.h: basic drawing canvas class .h file - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VDRAWING_H
#define VDRAWING_H

#include <v/v_defs.h>		// Basic defs
#include <v/vfont.h>		// for fonts
#include <v/vpen.h>		// for our pen

    typedef unsigned char ChrAttr;	// An attribute for a display char
    typedef unsigned char Chr;		// A character to display
    typedef int VCursor;		// For cursors

    typedef struct dChar		// A display Char
      {
	ChrAttr attr;			// The attribute of this char
	Chr chr;			// the character
      } dChar;

const ChrAttr ChNormal = 0;
const ChrAttr ChReverse = 0x01;
const ChrAttr ChBold = 0x02;
const ChrAttr ChUnderline = 0x04;
const ChrAttr ChAll = 0xFF;		// a mask

// Define Cursor stuff

const VCursor VC_None = 0;		// No/Default cursor
const VCursor VC_Arrow = 1;		// XC_top_left_arrow
const VCursor VC_CenterArrow = 2;	// XC_center_ptr
const VCursor VC_CrossHair = 3;		// XC_crosshair
const VCursor VC_EWArrows = 4;		// XC_sb_h_double_arrow
const VCursor VC_Hand = 5;		// XC_hand2
const VCursor VC_IBar = 6;		// XC_xterm
const VCursor VC_Icon = 7;		// XC_icon
const VCursor VC_NSArrows = 8;		// XC_sb_v_double_arrow
const VCursor VC_Pencil = 9;		// XC_Pencil
const VCursor VC_Question = 10;		// XC_question_arrow
const VCursor VC_Sizer = 11;		// XC_sizing
const VCursor VC_Wait = 12;		// XC_watch
const VCursor VC_X = 13;		// XC_X_cursor
const VCursor VC_LAST = 13;
const int maxCursors = 13;

    class vWindow;		// we are part of a window

    class vDrawingCanvas
      {
	public:		//---------------------------------------- public

	vDrawingCanvas();

 	virtual ~vDrawingCanvas();

	// Window management

	virtual void Clear(void);		// Clear canvas window
	// Clear canvas window
	virtual void ClearRect(int left, int top, int width, int height);

	// draw text with attributes
  	virtual void DrawAttrText(int x, int y, char* text, const ChrAttr attr);

	// Draw text in canvas
  	virtual void DrawText(int x, int y, char* text);
	// Draw a line in canvas
  	virtual void DrawLine(int x, int y, int xend , int yend);
	// Draw a rubber line in canvas
  	virtual void DrawRubberLine(int x, int y, int xend, int yend);

	virtual void FontChanged(int);		// Inform that font has changed
	virtual void SetFont(int);		// Set Text font to id

	virtual int GetWidth() { return _width; }   // Get width of canvas
	virtual int GetHeight() { return _height; } // Get Height of canvas

	// Events
	virtual void MouseDown(int x, int y, int button);	// Mouse Down at x,y
	virtual void MouseUp(int x, int y, int button);		// Mouse Up at x,y
	virtual void MouseMove(int x, int y, int button);	// Mouse Moved to x,y

	virtual void EnterFocus();
	virtual void LeaveFocus();

	// Expose/redraw event
	virtual void Redraw(int x, int y, int height , int width);
	virtual void Resize(int newH, int newW);  // Resize event

	// Appearance
	void SetCursor(VCursor id);
	void UnSetCursor(void);

	virtual void SetBackground(vColor color);
	virtual void SetPen(vPen pen);
	vPen GetPen() { return _pen; }

      protected:	//--------------------------------------- protected

	virtual void CreateDrawingCanvas(HWND pWidget, int dh, int dw);

	int _height;	// height of draw window
	int _width;	// width of draw window

	int _canvasFont;		// the font we are using

	unsigned long _canvasFG;	// the foreground color
	unsigned long _canvasBG;	// the background color

	HWND _drawWindow;		// window for drawing

	static VCursor _currentCursor;	// for cursor

      private:		//--------------------------------------- private

	int _hasFocus;			// for focus workaround

	vPen _pen;			// Our pen

	static int _currentFont;	// for SHARED GC

  	void SetGCtoPen();
	void ExposeEV(int x, int y, int height, int width);
	void EnterEV(void);
	void LeaveEV(void);
	void MouseUpEV(int x, int y, int button);
	void MouseDownEV(int x, int y, int button);
	void MouseMoveEV(int x, int y, int button);
      };
#endif
