/*
 * cluster.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __CLUSTER_H__
#define __CLUSTER_H__

#include "venus.h"

class Cluster;

class ClusterEntry
{
	friend Cluster;
protected:
	ClusterEntry *next;
	char *name;
public:
	ClusterEntry(char *aname, ClusterEntry *anext);
};

struct ClusterData
{
	int bit;
	int mask;
};

class Cluster: public View
{
protected:
	ClusterData data;
	ClusterEntry *first;
	int current;
public:
	Cluster(Rect bounds, ClusterEntry *afirst);
	~Cluster();
	int dataSize();
	virtual void drawBasic(char sign, char *style, int blip);
	void draw();
	virtual void drawState(int blip) = 0;
	virtual void findValid(int delta);
	void getData(void *buf);
	void handleEvent(Event &event);
	virtual void makePress(int item) = 0;
	void setData(void *buf);
};

class CheckBox: public Cluster
{
public:
	CheckBox(Rect bounds, ClusterEntry *afirst);
	void drawState(int blip);
	void handleEvent(Event &event);
	void makePress(int item);
};

class RadioBox: public Cluster
{
public:
	RadioBox(Rect bounds, ClusterEntry *afirst);
	void drawState(int blip);
	void findValid(int delta);
	void makePress(int item);
};

#endif
